#ifndef __XML_REGION_SOURCE_H__
#define __XML_REGION_SOURCE_H__

// Tue Feb 19 21:28:47 GMT 2002  by  nts

#include <sax2/SAX2XMLReader.hpp> // for  class SAX2XMLReader

// use Xerces namespace if necessary (for newer versions of Xerces and XML4C)
#ifdef XERCES_HAS_CPP_NAMESPACE
using namespace XERCES_CPP_NAMESPACE;
#else
#define XERCES_CPP_NAMESPACE
#endif

// our own includes
#include "tracker_defines_types_and_helpers.h"

namespace ReadingPeopleTracker
{

// forward declarations
class RegionSet;
class TrackedObjectSet;
class XMLRegionHandler;

////////////////////////////////////////////////////////////////////////////////////
//                                                                                //
// class XMLRegionSource      <<< abstract >>>                                    //
//                                                                                //
// This class defines an interface to XML Region data as defined by the XML       //
// Schema namespace "http://www.cvg.cs.reading.ac.uk/ADVISOR" (the current name). //
//                                                                                //
// Similar in design to our ImageSource classes, some methods are pure virtual    //
// and the class should therefore not be instantiated directly.                   //
//                                                                                //
// The XMLRegionSource class uses the XMLRegionHandler class to extract data from //
// the XML structures.                                                            //
//                                                                                //
////////////////////////////////////////////////////////////////////////////////////

class XMLRegionSource
{
protected:

    //////////////////////////////////////////////////////////////////////////
    //   Private member data                                                //
    //////////////////////////////////////////////////////////////////////////

    RegionSet *current_region_set;
    frame_id_t frame_count;
    
    XERCES_CPP_NAMESPACE::SAX2XMLReader *XML_parser;
    XMLRegionHandler *XML_region_handler;
 

public:

    //////////////////////////////////////////////////////////////////////////
    //   Constructor and Destructor                                         //
    //////////////////////////////////////////////////////////////////////////

    XMLRegionSource();
    ~XMLRegionSource();

    //////////////////////////////////////////////////////////////////////////
    //   Interface to get RegionSet for current and next frame              //
    //////////////////////////////////////////////////////////////////////////
    
    virtual RegionSet *get_current() = 0;
    virtual RegionSet *get_next() = 0;

    //////////////////////////////////////////////////////////////////////////
    //   Interface to get frame id of current RegionSet                     //
    //////////////////////////////////////////////////////////////////////////

    virtual frame_id_t get_frame_id() = 0;

    //////////////////////////////////////////////////////////////////////////
    //   Interface to get XMLRegionSource type (slave, ...)                 //
    //////////////////////////////////////////////////////////////////////////
    
    virtual XMLRegionSourceType get_source_type() const = 0;
};

} // namespace ReadingPeopleTracker

#endif
