
// Tue Feb 19 21:28:47 GMT 2002  by  nts

////////////////////////////////////////////////////////////////////////////////////
//                                                                                //
// class XMLRegionSource      <<< abstract >>>                                    //
//                                                                                //
// This class defines an interface to XML Region data as defined by the XML       //
// Schema namespace "http://www.cvg.cs.reading.ac.uk/ADVISOR" (the current name). //
//                                                                                //
// Similar in design to our ImageSource classes, some methods are pure virtual    //
//   and the class should not be instantiated directly.                           //
//                                                                                //
// The XMLRegionSource class uses the XMLRegionHandler class to extract data from //
//   the XML structures.                                                          //
//                                                                                //
////////////////////////////////////////////////////////////////////////////////////


// XML libraries for SAX2 API...
#include <util/PlatformUtils.hpp> // XMLPlatformUtils class with static init/deinit methods
#include <sax2/XMLReaderFactory.hpp>  // XMLReaderFactory class with static reader methods
#include <util/XMLString.hpp>    // XMLString class with static character conversion methods
#include <sax2/SAX2XMLReader.hpp>  // which defines the SAX2 XML parser class

// our own includes
#include "XMLRegionSource.h"
#include "XMLRegionHandler.h"
#include "RegionSet.h"
#include "TrackedObjectSet.h"
#include "text_output.h"

namespace ReadingPeopleTracker
{

//////////////////////////////////////////////////////////////////////////
//   Constructor and Destructor                                         //
//////////////////////////////////////////////////////////////////////////


XMLRegionSource::XMLRegionSource()
{
    // assign default values to detect errors during initialisation
    XML_region_handler = NULL;
    XML_parser = NULL;
    
    // Initialize the XML system
    try
    {
	XMLPlatformUtils::Initialize(); // apparently, this is per-process so OK
    }
    
    catch (const XMLException &exception)
    {
	char *message = XMLString::transcode(exception.getMessage());
	
	cerror << " XMLRegionSource::XMLRegionSource(): Error during initialization: "
	       << message
	       << " " << endl;
	
	delete [] message;
	
	// re-throw exception with our own message
	throw (" Cannot initialise XML input class ");
    }
    
    //  Create a SAX2 parser object
    XML_parser = XMLReaderFactory::createXMLReader();
    
    // disable validation (for speed reasons)
    XML_parser->setFeature(XMLString::transcode("http://xml.org/sax/features/validation"), false);
    XML_parser->setFeature(XMLString::transcode("http://apache.org/xml/features/validation/schema"), false);
    XML_parser->setFeature(XMLString::transcode("http://apache.org/xml/features/validation/schema-full-checking"), false);
    
    //  Create the handler object and install it as the document and error
    //  handler for the parser.
    try
    {
        XML_region_handler = new XMLRegionHandler;
        XML_parser->setContentHandler(XML_region_handler);
        XML_parser->setErrorHandler(XML_region_handler);
    }
    
    catch (const XMLException &exception)
    {
	char *message = XMLString::transcode(exception.getMessage());
	
	cerror << " XMLRegionSource::XMLRegionSource(): Error during handler initialization: "
	       << message
	       << " " << endl;
	
	delete [] message;
	
	// re-throw exception with our own message
	throw (" Cannot initialise XML handler class ");
    }
    
    frame_count = 0;
    current_region_set = NULL;
}

XMLRegionSource::~XMLRegionSource()
{
    //  Delete the parser.  Must be done prior to calling Terminate, below.
    delete XML_parser;
    
    // Call the termination method
    XMLPlatformUtils::Terminate(); // apparently, this is per-process so OK
}

} // namespace ReadingPeopleTracker
