
// Thu Feb 14 16:58:28 GMT 2002  by  nts

#ifndef __XML_REGION_HANDLER_H__
#define __XML_REGION_HANDLER_H__

class Attributes;  // this is from <sax2/Attributes.hpp>

// XML include for SAX2 API...
#include <sax2/DefaultHandler.hpp>

// use Xerces namespace if necessary (newer versions of Xerces and (hence) XML4C)
XERCES_CPP_NAMESPACE_USE

// our own includes
#include "tracker_defines_types_and_helpers.h"

namespace ReadingPeopleTracker
{

// forward declarations
class Region;
class RegionSet;

////////////////////////////////////////////////////////////////////////////////////
//                                                                                //
// class XMLRegionHandler : public DefaultHandler                                 //
//                                                                                //
// This class defines an interface to XML Region data as defined by the XML       //
// Schema namespace "http://www.cvg.cs.reading.ac.uk/ADVISOR" (the current name). //
//                                                                                //
// It is intended to be instantiated by an XMLRegionSource class to handle the    //
// low-level XML interpretation, generating and providing `RegionSet's created    //
// from the XML data provided.                                                    //
//                                                                                //
// The XMLRegionHandler class is derived from the XML SAX2 DefaultHandler class   //
// which is designed to ignore all requests.  We only redefine the methods that   //
// we need such that there is little overhead.                                    //
//                                                                                //
////////////////////////////////////////////////////////////////////////////////////

class XMLRegionHandler : public DefaultHandler
{
private:
    
    //////////////////////////////////////////////////////////////////////////
    //   Private member data                                                //
    //////////////////////////////////////////////////////////////////////////

    Region *new_region;                // current region we are building up
    RegionSet *current_region_set;     // result set for current frame ...
    bool have_valid_region_set;        // ... whether it is complete already ...
    bool region_set_has_been_queried;  // ... and whether it has been queried
    unsigned int parsing_level;        // current level in XML hierarchy
    
    frame_id_t frame_count;            // counting the frames as we go along
    

    //////////////////////////////////////////////////////////////////////////
    //   Private helper functions: indivudual data element handlers         //
    //////////////////////////////////////////////////////////////////////////    

    void handle_frame(const XERCES_CPP_NAMESPACE::Attributes *const attributes);
    void handle_blob(const XERCES_CPP_NAMESPACE::Attributes *const attributes);
    void handle_info2d(const XERCES_CPP_NAMESPACE::Attributes *const attributes);
    void handle_info3d(const XERCES_CPP_NAMESPACE::Attributes *const attributes);
    void handle_occlusion(const XERCES_CPP_NAMESPACE::Attributes *const attributes);
    
public:

    //////////////////////////////////////////////////////////////////////////
    //   Constructor and Destructor                                         //
    //////////////////////////////////////////////////////////////////////////

    XMLRegionHandler();
    ~XMLRegionHandler();

    //////////////////////////////////////////////////////////////////////////
    //   Interface to get RegionSet for current frame                       //
    //////////////////////////////////////////////////////////////////////////
    
    RegionSet *get_current();

    //////////////////////////////////////////////////////////////////////////
    //  Implementation of the SAX2 DocumentHandler interface                //
    //////////////////////////////////////////////////////////////////////////

    void startDocument();
    void endDocument();
    
    void startElement(const XMLCh *const uri,
		      const XMLCh *const localname,
		      const XMLCh *const qname,
		      const XERCES_CPP_NAMESPACE::Attributes &attributes);
    
    void endElement(const XMLCh *const uri, 
		    const XMLCh *const localname, 
		    const XMLCh *const qname);
    
// these are also available but not needed since all data is in attributes
//      void characters(const XMLCh *const chars, const unsigned int length);    
//      void ignorableWhitespace (const XMLCh *const chars, const unsigned int length);
//      void processingInstruction (const XMLCh *const target, const XMLCh *const data);
    
    //////////////////////////////////////////////////////////////////////////
    //  Implementation of the SAX2 ErrorHandler interface                   //
    //////////////////////////////////////////////////////////////////////////

    void warning(const SAXParseException &exception);
    void error(const SAXParseException &exception);
    void fatalError(const SAXParseException &exception);
};

} // namespace ReadingPeopleTracker

#endif
