///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  text_output.h       define the ostreams cinfo, cerror etc                //
//                                                                           //
//  Author    : Nils T Siebel (nts)                                          //
//  Created   : Mon Jan 21 18:08:40 GMT 2002                                 //
//  Revision  : 1.0 of Wed Jan 23 17:37:00 GMT 2002                          //
//  Copyright : The University of Reading                                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __TEXT_OUTPUT_H__
#define __TEXT_OUTPUT_H__

#include <iostream>

using namespace std;

namespace ReadingPeopleTracker
{

static const char *text_output_Revision = "@(#) text_output.h, rev 1.0 of Wed Jan 23 17:37:00 GMT 2002, Author Nils T Siebel, Copyright (c) 2002 The University of Reading";

//
// the following ostream classes are defined below
//
// static ostream &cinfo;     // for information messages
// static ostream &cerror;    // for error messages
// static ostream &cdebug;    // for debug messages


//
//  1 - declare an ostream class which ignores every operator<< request
//      FIXME: does not intercept many other methods so better don't call others than this
//
class nop_ostream : public ostream    // no-operation ostream: ignore all requests 
{
public:
    nop_ostream() : ostream (NULL)
	{
	    // nothing
	}
    
    ~nop_ostream()
	{
	    // nothing
	}
    
    // this method is called when code like `cdebug << endl' is executed.
    //    (the `func' parameter in this case would be the `endl' function)
    nop_ostream &operator<<(ostream &(*func)(ostream&))
	{
	    // nothing
	    return *this;
	}

    // this one is similar, although not currently called by our code
    nop_ostream &operator<<(ios &(*func)(ios&))
	{
	    // nothing
	    return *this;
	}

};

// overload operator<< with no-operation template operator<<
template <class type>
nop_ostream &operator<< (nop_ostream &outs, const type &data)
{
    // nothing
    return outs;
}

//
//  2 - declare and assign cdebug
//

#ifdef DEBUG

static ostream &cdebug = cerr;   // send to cerr for now...

#else

// no debug: assign to cdebug the nop_ostream defined above

static nop_ostream &cdebug = *(new nop_ostream);

#endif


//
//  3 - declare and assign cerror
//

static ostream &cerror = cerr;   // send to cerr for now...



//
//  4 - declare and assign cinfo
//

static ostream &cinfo = cerr;   // send to cerr for now...

} // namespace ReadingPeopleTracker

#endif
