// nts: changed to C++ style parameter format
// nts: renamed from .c to .h and added #ifndef __STRCASECMP_H__ etc
#ifndef __STRCASECMP_H__
#define __STRCASECMP_H__

/*
 * Copyright (c) 1987 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of California at Berkeley. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific written prior permission. This software
 * is provided ``as is'' without express or implied warranty.
 */

/*
  
@deftypefn Supplemental int strcasecmp (const char *@var{s1}, const char *@var{s2})

A case-insensitive @code{strcmp}.

@end deftypefn

*/

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)strcasecmp.c	5.5 (Berkeley) 11/24/87";
#endif /* LIBC_SCCS and not lint */

/*
 * This array is designed for mapping upper and lower case letter
 * together for a case independent comparison.  The mappings are
 * based upon ascii character sequences.
 */

#ifndef __STRNCASECMP_H__   // do not redefine this table
/*
 * This array is designed for mapping upper and lower case letter
 * together for a case independent comparison.  The mappings are
 * based upon ascii character sequences.
 */

// cast to unsigned char without taking up too much space when doing it 256 times
#define unch (unsigned char)
static const unsigned char charmap[] = {
	unch '\000',unch '\001',unch '\002',unch '\003',unch '\004',unch '\005',unch '\006',unch '\007',
	unch '\010',unch '\011',unch '\012',unch '\013',unch '\014',unch '\015',unch '\016',unch '\017',
	unch '\020',unch '\021',unch '\022',unch '\023',unch '\024',unch '\025',unch '\026',unch '\027',
	unch '\030',unch '\031',unch '\032',unch '\033',unch '\034',unch '\035',unch '\036',unch '\037',
	unch '\040',unch '\041',unch '\042',unch '\043',unch '\044',unch '\045',unch '\046',unch '\047',
	unch '\050',unch '\051',unch '\052',unch '\053',unch '\054',unch '\055',unch '\056',unch '\057',
	unch '\060',unch '\061',unch '\062',unch '\063',unch '\064',unch '\065',unch '\066',unch '\067',
	unch '\070',unch '\071',unch '\072',unch '\073',unch '\074',unch '\075',unch '\076',unch '\077',
	unch '\100',unch '\141',unch '\142',unch '\143',unch '\144',unch '\145',unch '\146',unch '\147',
	unch '\150',unch '\151',unch '\152',unch '\153',unch '\154',unch '\155',unch '\156',unch '\157',
	unch '\160',unch '\161',unch '\162',unch '\163',unch '\164',unch '\165',unch '\166',unch '\167',
	unch '\170',unch '\171',unch '\172',unch '\133',unch '\134',unch '\135',unch '\136',unch '\137',
	unch '\140',unch '\141',unch '\142',unch '\143',unch '\144',unch '\145',unch '\146',unch '\147',
	unch '\150',unch '\151',unch '\152',unch '\153',unch '\154',unch '\155',unch '\156',unch '\157',
	unch '\160',unch '\161',unch '\162',unch '\163',unch '\164',unch '\165',unch '\166',unch '\167',
	unch '\170',unch '\171',unch '\172',unch '\173',unch '\174',unch '\175',unch '\176',unch '\177',
	unch '\200',unch '\201',unch '\202',unch '\203',unch '\204',unch '\205',unch '\206',unch '\207',
	unch '\210',unch '\211',unch '\212',unch '\213',unch '\214',unch '\215',unch '\216',unch '\217',
	unch '\220',unch '\221',unch '\222',unch '\223',unch '\224',unch '\225',unch '\226',unch '\227',
	unch '\230',unch '\231',unch '\232',unch '\233',unch '\234',unch '\235',unch '\236',unch '\237',
	unch '\240',unch '\241',unch '\242',unch '\243',unch '\244',unch '\245',unch '\246',unch '\247',
	unch '\250',unch '\251',unch '\252',unch '\253',unch '\254',unch '\255',unch '\256',unch '\257',
	unch '\260',unch '\261',unch '\262',unch '\263',unch '\264',unch '\265',unch '\266',unch '\267',
	unch '\270',unch '\271',unch '\272',unch '\273',unch '\274',unch '\275',unch '\276',unch '\277',
	unch '\300',unch '\341',unch '\342',unch '\343',unch '\344',unch '\345',unch '\346',unch '\347',
	unch '\350',unch '\351',unch '\352',unch '\353',unch '\354',unch '\355',unch '\356',unch '\357',
	unch '\360',unch '\361',unch '\362',unch '\363',unch '\364',unch '\365',unch '\366',unch '\367',
	unch '\370',unch '\371',unch '\372',unch '\333',unch '\334',unch '\335',unch '\336',unch '\337',
	unch '\340',unch '\341',unch '\342',unch '\343',unch '\344',unch '\345',unch '\346',unch '\347',
	unch '\350',unch '\351',unch '\352',unch '\353',unch '\354',unch '\355',unch '\356',unch '\357',
	unch '\360',unch '\361',unch '\362',unch '\363',unch '\364',unch '\365',unch '\366',unch '\367',
	unch '\370',unch '\371',unch '\372',unch '\373',unch '\374',unch '\375',unch '\376',unch '\377',
};
#undef unch

#endif

static int
strcasecmp(const char *s1, const char *s2)
{
    register unsigned char u1, u2;

    for (;;) {
	u1 = (unsigned char) *s1++;
	u2 = (unsigned char) *s2++;
	if (charmap[u1] != charmap[u2]) {
	    return charmap[u1] - charmap[u2];
	}
	if (u1 == '\0') {
	    return 0;
	}
    }
}

#endif
