/***************************************************************
 * C - C++ Header
 *
 * File : 	realno.h
 *
 * Module :	realno
 *
 * Author : 	A M Baumberg (CoMIR)
 *
 * Creation Date : Mon Jul 15 13:04:32 1996 
 *
 * Comments : 	some macros
 *
 ***************************************************************/


#ifndef __REALNO_H__
#define __REALNO_H__

#include <float.h>

namespace ReadingPeopleTracker
{

#ifdef USE_FLOAT

typedef float realno;
#define real_cos fcos
#define real_sin fsin
#define real_exp fexp
#define real_tan ftan
#define real_atan2 fatan2
#define real_log flog
#define real_sqrt fsqrt 

#ifdef WIN32
#define real_isnan _isnan
#else
#define real_isnan isnan
#endif

#else // ifdef USE_FLOAT

typedef double realno;
#define real_cos cos
#define real_sin sin
#define real_exp exp
#define real_tan tan
#define real_atan2 atan2
#define real_log log
#define real_sqrt sqrt 

#ifdef WIN32
#define real_isnan _isnan
#else
#define real_isnan isnan
#endif

#endif // ifdef USE_FLOAT

inline int real_to_int(realno x)
{
  if (x < 0)
    return (int) (x-0.5);
  else
    return (int) (x+0.5);
}

} // namespace ReadingPeopleTracker

#endif



