//
//  OS-specific `#define's and `typedef's, centralised to make porting easier.
//
//  created by nts on Wed Apr  3 18:23:00 BST 2002

////
////  NB We are included by tracker_defines_types_and_helpers.h
////
////  Sometimes, you might still want to include this file directly.
////

#ifndef __OS_SPECIFIC_THINGS_H__
#define __OS_SPECIFIC_THINGS_H__

#ifdef WIN32
#include <wtypes.h>   // for ULONGLONG etc
#include <windows.h>  // this defines the common exit(code), among others
#include <winbase.h>  // this defines the Sleep(ms), among others
#endif

#ifdef WIN32
#include <ostream>  // because we need to define an ostream &operator<<
#endif

#ifdef _BSD_SOURCE
#include <unistd.h>   // for sleep(sec), usleep(usec)
#else
#ifndef WIN32
#ifdef DEBUG
#ifndef NO_DISPLAY
extern "C"   // use this non-portable sleep function:
{
    unsigned int sleep (unsigned int seconds);
}
#endif  // ifndef NO_DISPLAY
#endif  // ifdef DEBUG
#endif  // ifndef WIN32
#endif  // ifdef _BSD_SOURCE else

#ifdef _POSIX_PRIORITY_SCHEDULING
// which is defined on POSIX systems by <unistd.h>
#include <pthread.h>  // to get sched_yield() if available
#endif

//
// 1 - we use the BSD 4.3 strn?casecmp (case-insensitive string comparison).
//
#ifdef WIN32
// Windows calls it under a different name (and so does OS/2 but never mind)
#define strcasecmp  _stricmp
#define strncasecmp  _strnicmp
#else
// Other systems: Check for BSD compatible compiler extension:
#ifndef _BSD_SOURCE
// BSD, and hence strcasecmp not available.  Include a file from UCB which defines it:
#include "strcasecmp.h"   // this is code from the University of California at Berkeley
#include "strncasecmp.h"  // this is code from the University of California at Berkeley
#endif
#endif

//
// 2 - maximum length of a hostname
//
// SUSv2 guarantees that `Host names are limited to 255 bytes'.  POSIX
// 1003.1-2001 guarantees that `Host names (not including the terminating NUL)
// are limited to HOST_NAME_MAX bytes'.  However, not all systems define this.
#ifndef HOST_NAME_MAX
#define HOST_NAME_MAX 255
#endif

//
// 3 - Windows calls the u_int64_t type "MIDL_uhyper", or "ULONGLONG" (see <wtypes.h>)
//
#ifdef WIN32
typedef DWORD u_int32_t;       // an unsigned 32-bit integer
typedef ULONGLONG u_int64_t;   // an unsigned 64-bit integer
#endif


//
// 4 - Windows does not have the POSIX.1 unsigned int sleep(unsigned int seconds)
//
#ifdef WIN32
// void Sleep (DWORD milliseconds)  where DWORD is a u_int32_t
inline unsigned int sleep(unsigned int seconds)
    {
	Sleep((DWORD) 1000 * seconds);
	return 0;
    }
#endif

//
// 5 - Windows does not have an ostream &operator<< (ostream &out, const u_int64_t &number)
//
#ifdef WIN32
static ostream &operator<< (ostream &out, const u_int64_t &number)
{
    out << (DWORD) (number / 1000000000000000)  // goes up to 18446
	<< (DWORD) ((number / 1000000000) % 1000000)
	<< (DWORD) (number % 1000000000);
    return out;
}
#endif

//
//  6 - usleep is BSD 4.3  (suspend execution for interval of microseconds)
//
#ifndef _BSD_SOURCE
inline void usleep(unsigned long usec)
{
    // cannot usleep on this system :-(  Let's do at least something
#ifdef WIN32
    Sleep ((DWORD) (usec / 1000));
#else
#ifdef _POSIX_PRIORITY_SCHEDULING
    // use POSIX 1003.1b-1993 (aka POSIX.4) sched_yield() to give up CPU...
    sched_yield();
    if (usec > 999)
	usec -= 1000;
#endif
    unsigned long a,b,c,d;
    
    // busy ourselves for some units of time...
    while (usec > 199)
    {
	// Try to convice the compiler we are actually making sense here...
	a = usec % 7;
	b = (usec + a) % 12;
	c = (usec + b) % 17;
	d = (usec + c) % 23;
	a = d;
	d = 200;   // get 200
	c = b;
	b = a;
	usec -= d; // subtract it
    }
#endif // ifdef WIN32 else
}
#endif // ifndef _BSD_SOURCE
    
#endif
