/*
This source file is the copyright property of the University of Leeds
('The University').

Permission to use, copy, modify, and distribute this source file for
educational, research, and not-for-profit purposes, without fee and
without a signed licensing agreement, is hereby granted, provided that
the above copyright notice, this paragraph and the following three
paragraphs appear in all copies, modifications, and distributions.

In no event shall The University be liable to any party for direct,
indirect, special, incidental or consequential damages, including lost
profits, arising out of the use of this software and its documentation.

The software is provided without warranty. The University has no obligation
to provide maintenance, support, updates, enhancements, or modifications.

This software was written by Adam Baumberg, Vision Group,
School of Computer Studies, University of Leeds, U.K. The code and use
thereof should be attributed to the author where appropriate (including
demonstrations which rely on it's use).
*/
/***************************************************************
 * C - C++ Header
 *
 * File : 	name_mangle.h
 *
 * Module :	name_mangle
 *
 * Author : 	A M Baumberg (CoMIR)
 *
 * Creation Date : Tue Jun  4 17:26:03 1996 
 *
 * Comments : 	change the extension of a filename
 *
 ***************************************************************/


#ifndef __NAME_MANGLE_H__
#define __NAME_MANGLE_H__

namespace ReadingPeopleTracker
{

// return a new filename obtained by
// substituting the file extension
// (if new_extension is NULL then remove trailing file extension)

char* name_mangle(const char* filename, const char* new_extension,
		  bool gobble_number = false);

} // namespace ReadingPeopleTracker

#endif
