/***************************************************************
 * C++ source
 *
 * File : 	name_mangle.cc
 *
 * Module :	name_mangle
 *
 * Author : 	A M Baumberg (CoMIR)
 *
 * Creation Date : Tue Jun  4 17:27:57 1996 
 *
 * Changes :    nts: added gobble_number flag to name_mangle numbered
 *              files, like camera38_0073.jpg to camera38.extension
 *
 ***************************************************************/


#include "name_mangle.h"

#include <cstdio>   // for sprintf()
#include <cctype>   // for isdigit()
#include <cstring>  // for strrchr()

namespace ReadingPeopleTracker
{

char* name_mangle(const char* filename, const char* new_extension,
		  bool gobble_number)
{
    if (filename == NULL) 
	return NULL;
    
    int ext_len = 0;
    
    if (new_extension != NULL)
	ext_len = strlen(new_extension);
    
    char* result = new char[strlen(filename) + ext_len + 1];
    
    strcpy(result, filename);
    
    char* old_extension = strrchr(result, '.');
    
    if (old_extension == NULL)
	old_extension = &result[strlen(filename)];
    
    if (gobble_number)
    {
	if (*old_extension == '.')
	    old_extension--;
	while (isdigit(*old_extension))
	    old_extension--;
	while ((*old_extension == '_') || (*old_extension == '-') ||
	       (*old_extension == '.'))
	    old_extension--;
	old_extension++;
    }
    
    if (new_extension != NULL)
	sprintf(old_extension,".%s", new_extension);
    else
	*old_extension = '\0';
    
    return result;
}

} // namespace ReadingPeopleTracker
