///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  icons.h                                                                 //
//                                                                           //
//  Icons for our programs                                                   //
//                                                                           //
//  We define 16x16 and 32x32 pixel icons for all main programs              //
//                                                                           //
//  NB all icons are copyrighted together with and like this source file is  //
//                                                                           //
//  Author    : Nils T Siebel (nts)                                          //
//  Created   : Thu Aug  9 10:25:10 BST 2001                                 //
//  Revision  : 0.2 of Wed Aug 15 14:42:38 BST 2001                          //
//  Copyright : The University of Reading                                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __ICONS_H__
#define __ICONS_H__

// include XPMs with colour icon data
#include "icons/STIB_YZER_c02_16.xpm"
#include "icons/STIB_YZER_c02_32.xpm"
#include "icons/feature_track_LUL1_16.xpm"
#include "icons/feature_track_LUL1_32.xpm"
#include "icons/data_extraction_RG1_16.xpm"
#include "icons/data_extraction_RG1_32.xpm"

//  // include XBMs with black and white icon data
//  #include "icons/STIB_YZER_c02_16.xbm"
//  #include "icons/STIB_YZER_c02_32.xbm"
//  #include "icons/person1_16.xbm"
//  #include "icons/person1_16_inverted.xbm"
//  #include "icons/person1_32.xbm"
//  #include "icons/person1_32_inverted.xbm"
//  #include "icons/people1_16.xbm"

namespace ReadingPeopleTracker
{

static const char *icons_Revision = "@(#) icons.h plus included icons, rev 0.3 of Tue Feb 25 10:25:21 GMT 2003, Author Nils T Siebel, Copyright (c) 2000--2003 The University of Reading";

// default icons
#define DEFAULT_ICON_16 STIB_YZER_c02_16_xpm
#define DEFAULT_ICON_32 STIB_YZER_c02_32_xpm

// use 16x16 icon for now...
#define ICON_WIDTH 16
#define ICON_HEIGHT 16
#define DEFAULT_ICON DEFAULT_ICON_16

// most of these use default icons for now...
#define calibrate_ground_plane_icon_16 DEFAULT_ICON_16
#define calibrate_ground_plane_icon_32 DEFAULT_ICON_32
#define data_extraction_icon_16 data_extraction_RG1_16_xpm
#define data_extraction_icon_32 data_extraction_RG1_32_xpm
#define feature_track_icon_16 feature_track_LUL1_16_xpm
#define feature_track_icon_32 feature_track_LUL1_32_xpm
#define get_reading_blobs_icon_16 DEFAULT_ICON_16
#define get_reading_blobs_icon_32 DEFAULT_ICON_32
#define ground_track_icon_16 STIB_YZER_c02_32_xpm
#define ground_track_icon_32 STIB_YZER_c02_32_xpm
#define process_sequence_icon_16 DEFAULT_ICON_16
#define process_sequence_icon_32 DEFAULT_ICON_32
#define quick_ground_track_icon_16 STIB_YZER_c02_16_xpm
#define quick_ground_track_icon_32 STIB_YZER_c02_32_xpm
#define simple_track_icon_16 STIB_YZER_c02_16_xpm
#define simple_track_icon_32 STIB_YZER_c02_32_xpm

} // namespace ReadingPeopleTracker

#endif
