///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  file Profiling.h                                                         //
//                                                                           //
//  This defines some very basic routines for timing events                  //
//                                                                           //
//  Author    : Nils T Siebel (nts)                                          //
//  Created   : Thu Nov  2 11:00:34 GMT 2000                                 //
//  Revision  : 1.10 of Thu Mar 28 12:00:33 GMT 2002                         //
//  Copyright : The University of Reading                                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __PROFILING_H__
#define __PROFILING_H__

#ifdef WIN32
#include <time.h>
#else
#include <sys/time.h>
#endif

namespace ReadingPeopleTracker
{

// completely static class (no contructor or destructor)

class Profiling
{
private:
    static unsigned long profiling_seconds;
    static unsigned long profiling_microseconds;
    
    static unsigned long starttime_seconds;
    static unsigned long starttime_microseconds;
    
    static struct timeval profiling_timeval;
    static struct timezone profiling_timezone;

public:
    static void initialise_timer();

    static void setusecs(unsigned long new_micro_seconds);

    static unsigned long getusecs();
};

} // namespace ReadingPeopleTracker

#endif
