///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  file Profiling.cc                                                        //
//                                                                           //
//  This defines some very basic routines for timing events                  //
//                                                                           //
//  Author    : Nils T Siebel (nts)                                          //
//  Created   : Thu Nov  2 11:00:34 GMT 2000                                 //
//  Revision  : 1.10 of Thu Mar 28 12:00:33 GMT 2002                         //
//  Copyright : The University of Reading                                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


#include <sys/time.h>
#include <unistd.h>

#include "Profiling.h"
#include "text_output.h"

namespace ReadingPeopleTracker
{

static const char* Profiling_Revision = "@(#) Profiling.cc, rev 1.10 of Thu Mar 28 12:00:33 GMT 2002, Author Nils T Siebel, Copyright (c) 2000--2002 The University of Reading";


// definition and initialisation of static member variables
unsigned long Profiling::profiling_seconds = 0;
unsigned long Profiling::profiling_microseconds = 0;

unsigned long Profiling::starttime_seconds = 0;
unsigned long Profiling::starttime_microseconds = 0;

struct timeval Profiling::profiling_timeval;
struct timezone Profiling::profiling_timezone;


void Profiling::initialise_timer()
{
    gettimeofday(&profiling_timeval,&profiling_timezone);

    starttime_microseconds = profiling_timeval.tv_usec;
    
    cdebug << "Profiling::initialise_timer: start time "
	   << profiling_timeval.tv_sec << "."
	   << starttime_microseconds << " sec " << endl;
}

    

void Profiling::setusecs(unsigned long new_micro_seconds)
{
    profiling_seconds = new_micro_seconds / 1000000;
    profiling_microseconds = new_micro_seconds % 1000000;

    gettimeofday(&profiling_timeval,&profiling_timezone);

    starttime_seconds = profiling_timeval.tv_sec;
    starttime_microseconds = profiling_timeval.tv_usec;
}

unsigned long Profiling::getusecs()
{
    gettimeofday(&profiling_timeval,&profiling_timezone);
    return (1000000*(profiling_timeval.tv_sec - starttime_seconds)
	    + profiling_timeval.tv_usec - starttime_microseconds);
}

} // namespace ReadingPeopleTracker
