///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  NumberedFiles.h   Helper (base) class to read or write numbered files.   //
//                                                                           //
//  Author    : Nils T Siebel (nts)                                          //
//  Created   : Mon Apr  8 09:35:38 BST 2002                                 //
//  Revision  : 0.0 of Mon Apr  8 09:35:38 BST 2002                          //
//  Copyright : The University of Reading                                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __NUMBERED_FILES_H__
#define __NUMBERED_FILES_H__

#include <cassert>
#include <cstdio>   // for FILE type

#include "tracker_defines_types_and_helpers.h" // for frame_id_t type

namespace ReadingPeopleTracker
{

// NumberedFiles: A helper class to read or write numbered files.

class NumberedFiles
{
private:
    
    // for numbered files, what comes before and after the number
    char filename_base[256];
    char filename_ext[64];
    char current_filename[256+16+64];

    unsigned int filename_num_digits;  // number of digits frame_number is padded to in sprintf

    frame_id_t start_frame_number;     // number of first file
    frame_id_t current_frame_number;   // number of current file
    frame_id_t file_count;             // counting as we read them

protected:
    
    // this current file will be used by derived classes
    FILE *current_file;
    
public:
    
    // constructor, desctructor
    NumberedFiles(char *first_filename);
    ~NumberedFiles();        

    char *get_next_filename();

    inline const char *get_current_filename() const
	{
	    return current_filename;
	}

    inline frame_id_t get_current_frame_number() const
	{
	    return current_frame_number;
	}
    
    inline frame_id_t get_file_count() const
	{
	    return file_count;
	}

protected:
    NumberedFiles()
        {
            bool this_is_recommended = false;
            assert (this_is_recommended == true);  // do not use the copy contructor
        }

};

} // namespace ReadingPeopleTracker

#endif

