///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  NumberedFileSource.h   A class to read numbered files into memory.       //
//                                                                           //
//  Author    : Nils T Siebel (nts)                                          //
//  Created   : Tue Apr  9 19:00:06 BST 2002                                 //
//  Revision  : 0.0 of Tue Apr  9 19:00:06 BST 2002                          //
//  Copyright : The University of Reading                                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __NUMBERED_FILE_SOURCE_H__
#define __NUMBERED_FILE_SOURCE_H__

#include <cassert>
#include <cstdio>   // for FILE type, fopen(...), fread(...)

#include "NumberedFiles.h"

// #include "tracker_defines_types_and_helpers.h" // for frame_id_t type

namespace ReadingPeopleTracker
{

// NumberedFileSource: A class to read numbered files into memory.

class NumberedFileSource : public NumberedFiles
{
private:
    
    // data read from the current file
    unsigned char *data_block;

    // size of current data block (in bytes).
    size_t data_block_size;

public:
    
    // constructor, desctructor
    NumberedFileSource(char *first_filename) : NumberedFiles(first_filename)
	{
	    data_block = NULL;     // no data block yet
	    data_block_size = 0;   // hence no bytes
	}

    ~NumberedFileSource()
	{
	    // nothing
	}
    
    // get and return next data block
    unsigned char *get_next();
	
    // return size of current data block
    inline size_t get_current_size() const
	{
	    return data_block_size;
	}

private:
    NumberedFileSource()
        {
            bool this_is_recommended = false;
            assert (this_is_recommended == true);  // do not use the copy contructor
        }

};

} // namespace ReadingPeopleTracker

#endif

