/***************************************************************
 * C - C++ Header
 *
 * File : 	EnvParameter.h
 *
 * Module :	
 *
 * Author : 	A M Baumberg (CoMIR)
 *
 * Creation Date : Tue Feb 28 09:22:37 1995 
 *
 * Comments : 	
 *
 ***************************************************************/


// An Enviroment Parameter is a boolean switch which may
// be set on or off by use of a shell environment variable

#ifndef __ENV_PARAMETER_H__
#define __ENV_PARAMETER_H__

#include <stdlib.h>
#include <string.h>

#include "realno.h"
#include "tracker_defines_types_and_helpers.h"
#include "text_output.h"

namespace ReadingPeopleTracker
{

#define ENV_VERBOSE "ENV_VERBOSE"


// should be EnvBoolParam
class EnvParameter
{
private:
    
    bool flag;
    
public:
    
    EnvParameter(char* shell_string, bool def = true)
	{
	    char* s = getenv(shell_string);
	    if (s == NULL) // undefined set flag to default
		flag = def;
	    else
	    {
		flag = !def;
		if (strcasecmp(s, "OFF") == 0) flag = false;
		if (strcasecmp(s, "ON") == 0)  flag = true;
		
		if (strcmp(s, "0") == 0) flag = false;
		if (strcmp(s, "1") == 0)  flag = true;
		
	    }
	    if (getenv(ENV_VERBOSE) != NULL)
	    {
		if (flag)
		    cinfo << shell_string << ": enabled\n";
		else
		    cinfo << shell_string << ": disabled\n";
	    }
	}
    
    void set_on() { flag = true; }
    void set_off() { flag = false; }
    void change_state() { flag = !flag; }
    bool get_state() { return flag; }
    bool is_on() { return flag == true; }
    bool is_off() { return flag == false; }
};

class EnvIntParameter
{
public:
    
    int value;
    
public:
    
    EnvIntParameter(char* shell_string, int def = 0)
	{
	    char* s = getenv(shell_string);
	    if (s == NULL) 
		value = def;
	    else
		value = atoi(s);
	    
	    if (getenv(ENV_VERBOSE) != NULL)
		cinfo << shell_string << " = " << value << endl;
	}
};


class EnvRealParameter
{
public:
    
    realno value;
    
public:
    
    EnvRealParameter(char* shell_string, realno def = 0)
	{
	    char* s = getenv(shell_string);
	    if (s == NULL) 
		value = def;
	    else
		value = atof(s);
	    
	    if (getenv(ENV_VERBOSE) != NULL)
		cinfo << shell_string << " = " << value << endl;
	}
};

class EnvStringParameter
{
public:
    
    char* value;
    
    EnvStringParameter(char* var_name, char* default_str = "")
	{
	    char* s = getenv(var_name);
	    if (s == NULL)
		value = default_str;
	    else
		value = s;
	    
	    if (getenv(ENV_VERBOSE) != NULL)
		cinfo << var_name << " = " << value << endl;
	}
};

} // namespace ReadingPeopleTracker

#endif
