#ifndef __TRACKING_H__
#define __TRACKING_H__

namespace ReadingPeopleTracker
{

// forward declarations
class Camera;
class ConfigurationManager;
class MotionDetector;
class RegionTracker;
class HumanFeatureTracker;
class ActiveShapeTracker;
class Inputs;
class Results;

class Tracking
{
private:
    
    // Detectors and Trackers
    MotionDetector *motion_detector;
    RegionTracker *region_tracker;
    HumanFeatureTracker *human_feature_tracker;
    ActiveShapeTracker *active_shape_tracker;
    
    bool use_region_tracker;
    bool use_human_feature_tracker;
    bool use_active_shape_tracker;
    
    // file names of configuration files of detectors and trackers
    char *motion_detector_filename;
    char *region_tracker_filename;
    char *human_feature_tracker_filename;
    char *active_shape_tracker_filename;
    
public:
    
    Tracking(ConfigurationManager *configuration_manager);
    
    ~Tracking();
   
    void setup_motion_detector_and_trackers(Inputs *inputs,
					    Results *results,
					    char *camera_configuration_filename_base);

    // generate motion images (background, difference, motion) unless they are in inputs
    void generate_motion_image(Inputs *inputs, Results *results);

    // extract motion data (moving regions) from motion image or get them from inputs
    void extract_motion_data(Inputs *inputs, Results *results);
    
    // run all trackers using motion detection and other data from inputs and results
    void run_trackers(Inputs *inputs, Results *results);

    // accessors
    inline RegionTracker *get_region_tracker() const
	{
	    return region_tracker;
	}
    inline HumanFeatureTracker *get_human_feature_tracker() const
	{
	    return human_feature_tracker;
	}
    inline ActiveShapeTracker *get_active_shape_tracker() const
	{
	    return active_shape_tracker;
	}
    inline MotionDetector *get_motion_detector() const
	{
	    return motion_detector;
	}
    
};

} // namespace ReadingPeopleTracker

#endif
