// copied stuff from pte's Tracking.h  nts on Thu Oct 25 18:51:10 2001

#include <cassert>
#include <cstring> // for strlen(...)

#include "Tracking.h"
#include "MotionDetector.h"
#include "RegionTracker.h"
#include "HumanFeatureTracker.h"
#include "ActiveShapeTracker.h"
#include "Inputs.h"
#include "Results.h"
#include "OcclusionImage.h"
//#include "OcclusionHandler.h"
#include "text_output.h"

namespace ReadingPeopleTracker
{

Tracking::Tracking(ConfigurationManager *configuration_manager)
{
    use_region_tracker =
	configuration_manager->register_bool("USE_REGION_TRACKER",
					     false, &use_region_tracker,
					     false, "Tracking",
					     "Shall we use a region tracker.");
    
    use_human_feature_tracker =
	configuration_manager->register_bool("USE_HUMAN_FEATURE_TRACKER",
					     false, &use_human_feature_tracker,
					     false, "Tracking",
					     "Shall we use a human feature tracker.");
    
   use_active_shape_tracker =
	configuration_manager->register_bool("USE_ACTIVE_SHAPE_TRACKER",
					     false, &use_active_shape_tracker,
					     false, "Tracking",
					     "Shall we use an active shape tracker.");
    
    region_tracker = NULL;
    human_feature_tracker = NULL;
    active_shape_tracker = NULL;
    motion_detector = NULL;
}

Tracking::~Tracking()
{
    if (active_shape_tracker != NULL)  delete active_shape_tracker;
    if (human_feature_tracker != NULL)  delete human_feature_tracker;
    if (region_tracker != NULL)  delete region_tracker;
    if (motion_detector != NULL)  delete motion_detector;  
}

void Tracking::setup_motion_detector_and_trackers(Inputs *inputs,
						  Results *results,
						  char *camera_configuration_filename_base)
{
    assert (camera_configuration_filename_base != NULL);  // we need it
    
    // generate tracker configuration file names by using the camera configuration file
    //   name and appending "-MD" etc (use uppercase initials of modules, up to 3)
    size_t filename_length = strlen(camera_configuration_filename_base) + 1 + 3 + 2;
    
    assert(filename_length > 0 + 1 + 3 + 2);   // we need a proper name here
    
    motion_detector_filename = new char[filename_length];
    region_tracker_filename = new char[filename_length];
    human_feature_tracker_filename = new char[filename_length];
    active_shape_tracker_filename = new char[filename_length];
    
    sprintf(motion_detector_filename,"%s-MD",camera_configuration_filename_base);
    sprintf(region_tracker_filename,"%s-RT",camera_configuration_filename_base);
    sprintf(human_feature_tracker_filename,"%s-HFT",camera_configuration_filename_base);
    sprintf(active_shape_tracker_filename,"%s-AST",camera_configuration_filename_base);
    
    motion_detector = new MotionDetector(inputs, motion_detector_filename);
    
    results->set_occlusion_image(new OcclusionImage(inputs->get_video_image_source()->get_xdim(),
						    inputs->get_video_image_source()->get_ydim(),
						    inputs->get_occlusion_resample_shift()));
    
//  	    results->set_occlusion_handler(
//  		new WorldOcclusionHandler(inputs->video_source, 
//  					  motion_detector, 
//  					  results->profile_set,
//  					  inputs->quick_mode,
//  					  calibration));
    
    
    if (use_region_tracker)
	region_tracker = new RegionTracker (inputs->get_calibration(),
					    motion_detector,
					    region_tracker_filename);
    else
	region_tracker = NULL;
    
    if (use_human_feature_tracker)
	human_feature_tracker = new HumanFeatureTracker (inputs->get_calibration(),
							 human_feature_tracker_filename);
    else
	human_feature_tracker = NULL;
    
    if (use_active_shape_tracker)
	active_shape_tracker = new ActiveShapeTracker (inputs,
						       motion_detector,
						       active_shape_tracker_filename);
    else
	active_shape_tracker = NULL;
}

//
// check availability of external motion and background image
//   and create with our own MotionDetector what is not available...
//
void Tracking::generate_motion_image(Inputs *inputs, Results *results)
{
    Image *current_external_motion_image;
    Image *current_external_background_image;
    
    // check whether external background and motion images are available:
    current_external_background_image = inputs->get_external_background_image();
    current_external_motion_image = inputs->get_external_motion_image();
    
    //
    //  1 - background image: put external one into results if we have it, else create it
    //
    if (current_external_background_image != NULL)
	results->set_background_image(current_external_background_image);
    else
    {
#ifdef ADVISOR
	cerror << " Tracking::generate_motion_image: Error: background image for frame "
	       << inputs->get_frame_id()
	       << " unavailable, trying our own MotionDetector..." << endl;
	
#endif
	motion_detector->update_background_image(inputs, results);
    }
    
    //
    //  2 - motion image: put external one into results if we have it, else create it
    //
    if (current_external_motion_image != NULL)
	results->set_motion_image(current_external_motion_image);
    else
    {
#ifdef ADVISOR
	cerror << " Tracking::generate_motion_image: Error: motion image for frame "
	       << inputs->get_frame_id()
	       << " unavailable, trying our own MotionDetector..." << endl;
#endif
	
	motion_detector->generate_motion_image(inputs, results);
    }
}


//
// check availability of external motion regions
//   and create with our own MotionDetector what is not available...
//
//   NB: this method calls MotionDetector::extract_new_regions which CLEARs the motion
//       image.  This means you should display the image before calling this method.
//
void Tracking::extract_motion_data(Inputs *inputs, Results *results)
{
    // check whether external data is available
    if (inputs->get_external_xml_region_set() != NULL)
    {
	// adjust external data: extract 
	ListNode<Region> *curr;
	
	Image *motion_image = results->get_motion_image();
	
	for (curr = inputs->get_external_xml_region_set()->first; curr != NULL; curr = curr->next)
	{
	    Region *reg = curr->dat;
	    
	    // for each Region: first create a region image
	    reg->region_img = motion_image->get_subimage(reg->xlo,reg->xhi, reg->ylo,reg->yhi);
	    
	    // secondly, add this Observation to tracked objects
	    results->get_tracked_objects()->add_observation(curr->dat,
							    inputs->get_frame_id(),
							    inputs->get_frame_time_in_ms());
	}
    }
    else
    {
	// no external motion data available, extract it using our own MotionDetector

	if (inputs->use_external_xml_region_source())  //  (should it have been available?)
	{
#ifdef ADVISOR
	    cerror << " Tracking::extract_motion_data: Warning: moving regions for frame "
		   << inputs->get_frame_id()
		   << " unavailable, trying our own MotionDetector..." << endl;
#endif
	}
	
	motion_detector->extract_new_regions(inputs, results);
    }
}

void Tracking::run_trackers(Inputs *inputs, Results *results)
{
    unsigned int max_objects = 32;
    
    //
    //  1 - processing
    //
    if (use_region_tracker)
	region_tracker->process_frame(inputs, results, max_objects);
    
    if (use_human_feature_tracker)
	human_feature_tracker->process_frame(inputs, results, max_objects);
    
    if (use_active_shape_tracker)
	active_shape_tracker->process_frame(inputs, results, max_objects);
    
    //
    //  2 - post processing, in reverse order:
    //      check against other measurements again and clean up...
    if (use_active_shape_tracker)
	active_shape_tracker->post_process_frame(inputs, results);
    
   if (use_human_feature_tracker)
	human_feature_tracker->post_process_frame(inputs, results);
    
    if (use_region_tracker)
	region_tracker->post_process_frame(inputs, results);
}

} // namespace ReadingPeopleTracker
