///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  TrackedObjectSet.h                                                       //
//                                                                           //
//  List to hold `TrackedObject's                                            //
//                                                                           //
//  Author    : Nils T Siebel (nts)                                          //
//  Created   : Tue Oct 23 12:04:12 BST 2001                                 //
//  Revision  : 1.5 of Tue Jun 18 16:47:21 BST 2002                          //
//  Copyright : The University of Reading                                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __TRACKED_OBJECT_SET_H__
#define __TRACKED_OBJECT_SET_H__

#include "TrackedObject.h"
#include "List.h"
#include "tracker_defines_types_and_helpers.h"

namespace ReadingPeopleTracker
{

class TrackedObjectSet : public List<TrackedObject>
{
public:
    TrackedObjectSet()
	{
	    first = last = NULL;
	    no_items = 0;
	}
    
    ~TrackedObjectSet()
	{
	    destroy_all();
	}
    
    TrackedObjectSet &operator= (TrackedObjectSet &original)
  	{
	    List<TrackedObject>::operator=(original);
	    return *this;
  	}
    
    // these methods are used to add objects to the list or to replace/update
    // existing ones with observations, comparing measurements to be added
    // whether they match existing measurements (not necessarily of the same
    // type) and changing the object's id accordingly.
    TrackedObject *add_observation(Region *region,
				   frame_id_t current_frame_id,
				   frame_time_t current_frame_time);
    TrackedObject *add_observation(Profile *profile,
				   frame_id_t current_frame_id,
				   frame_time_t current_frame_time);
    TrackedObject *add_observation(HumanFeatures *features,
				   frame_id_t current_frame_id,
				   frame_time_t current_frame_time);
    void add_observations(RegionSet *region_set,
			  frame_id_t current_frame_id,
			  frame_time_t current_frame_time);
    void add_observations(ProfileSet *profile_set,
			  frame_id_t current_frame_id,
			  frame_time_t current_frame_time);
    void add_observations(HumanFeatureSet *feature_set,
			  frame_id_t current_frame_id,
			  frame_time_t current_frame_time);
    
    // check all object `id's.  If they are 0, create new id.
    void check_and_create_ids();
    
    // remove (destroy) old objects from set
    void remove_old_tracks(frame_id_t current_frame_id,
			   frame_id_t max_age);
    
   
    // drawing functions: into Image
    void draw_all_in_image (Image *canvas,
			    frame_id_t min_age = 0);

};

} // namespace ReadingPeopleTracker

#endif

