///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  TrackedObject.cc                                                         //
//                                                                           //
//  Storage class for tracked objects (person, group, car, other) holding    //
//    all data from all trackers                                             //
//                                                                           //
//  Author    : Nils T Siebel (nts)                                          //
//  Created   : Tue Oct 23 14:26:53 BST 2001                                 //
//  Revision  : 0.0 of Tue Oct 23 14:26:53 BST 2001                          //
//  Copyright : The University of Reading                                    //
//                                                                           //
//  Changes:                                                                 //
//    nts: rev 0.1: initial working revision   The Future                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include "TrackedObject.h"
#include "Calibration.h"
#include "PeopleTracker.h"

namespace ReadingPeopleTracker
{

static const char *TrackedObject_Revision = "@(#) TrackedObject.cc, rev 0.0 of Tue Oct 23 14:26:53 BST 2001, Author Nils T Siebel, Copyright (c) 2001 The University of Reading";

// constructor: region
TrackedObject::TrackedObject(Region *region, ObjectType obj_type)
{
    allocate_datasets();
    reset_variables();
    type = obj_type;
    
    // add observation for this object
    regions->add(region);
}

// constructor: profile (single person)
TrackedObject::TrackedObject(Profile *profile, ObjectType obj_type)
{
    allocate_datasets();
    reset_variables();
    type = obj_type;

    // add observation for this object
    profiles->add(profile);
}

// constructor: human features
TrackedObject::TrackedObject(HumanFeatures *feature, ObjectType obj_type)
{
    allocate_datasets();
    reset_variables();
    type = obj_type;

    // add observation for this object
    features->add(feature);
}

// = operator (for TrackedObjectSet::duplicate() etc)
TrackedObject &TrackedObject::operator= (TrackedObject &original)
{
    // copy over variable values
    type = original.type;
    id = original.id;

    is_visible = original.is_visible;
    is_static = original.is_static;
    frames_static = original.frames_static;
    
    // allocate memory in order to copy over data using the operator=
    if (regions == NULL)
	regions = new RegionSet;
    
    if (features == NULL)
	features = new HumanFeatureSet;

    if (profiles == NULL)
	profiles = new ProfileSet;
    
    // now use the = operators to copy over data
    *regions = *original.regions;
    *features = *original.features;
    *profiles = *original.profiles;

    // only copy the pointer for calibration object
    calibration = original.calibration;

    return *this;
}


object_id_t TrackedObject::check_and_create_id()
{
    if (id == 0)  // need new id
	id = PeopleTracker::create_new_id();  // use this static function

    return id;
}

ostream &operator<< (ostream &out, const TrackedObject &object)
{
    out << "=====  Tracked Object id " << object.id
	<< " (";
    
    if (object.is_visible)
	out << "visible";
    else
	out << "not visible";
   
    out << ", frames static " << object.frames_static << ")  =====" << endl
	<< " Profiles " << *object.profiles
	<< " Regions  " << *object.regions;
// FIXME: crashes. check memory allocation and `operator='s 	<< " Features " << *object.features

    
    return out;
}

istream &operator>> (istream &in, TrackedObject &object) 
{
    bool this_is_implemented = false;
    assert (this_is_implemented == true);  // TrackedObject   operator>> not implemented

    return in;
}

} // namespace ReadingPeopleTracker
