// nts Thu Jan 10 19:34:34 GMT 2002 from Outputs.h by pte

#ifndef __SCREEN_OUTPUT_H__
#define __SCREEN_OUTPUT_H__

#include "tracker_defines_types_and_helpers.h" // for frame_id_t

namespace ReadingPeopleTracker
{

class Camera;
class ConfigurationManager;
class MovieStore;
class Inputs;
class Results;

class ScreenOutput
{
private:
    bool show_video_images;
    bool show_motion_images;
    bool show_background_images;
    bool show_difference_images;
    bool show_filtered_difference_images;
    bool show_thresholded_difference_images;
//      bool show_occlusion_images;    

    bool draw_regions;
    bool draw_features;
    bool draw_profiles;
    bool draw_label;


public:

//    //allows config manager access to private members
//    friend class ConfigurationManager;
//    friend class Camera;

    ScreenOutput(ConfigurationManager *configuration_manager);

    ~ScreenOutput()
	{
	    // nothing
	}

    // update all image displays
    void update_displays(Inputs *inputs, Results *results);
    
    // draw motion detection data into the motion image
    void draw_motion_data(Inputs *inputs, Results *results);

    // draw tracking results into respective images
    void draw_results(Inputs *inputs, Results *results, frame_id_t min_draw_age = 0);

private:
    // private helpers
    
    
    void register_configuration_paramaters(ConfigurationManager *configuration_manager);
  
};

} // namespace ReadingPeopleTracker

#endif
