// copied stuff from pte's header file into this cc --- nts on Thu Oct 25 14:21:19 2001

#include "ScreenOutput.h"
#include "ConfigurationManager.h"
#include "Inputs.h"
#include "Results.h"
#include "text_output.h"
#include "tracker_defines_types_and_helpers.h"

namespace ReadingPeopleTracker
{

// update all image displays
void ScreenOutput::update_displays(Inputs *inputs, Results *results)
{
    // display all those images which are to be displayed
    if (show_video_images)
	inputs->get_video_image()->display();
    
    if (show_motion_images)
	    results->get_motion_image()->display();
    
    if (show_background_images)
        results->get_background_image()->display();
    
    if (show_difference_images)
        results->get_difference_image()->display();
    
    if (show_filtered_difference_images)
        results->get_filtered_difference_image()->display();
    
    if (show_thresholded_difference_images)
        results->get_thresholded_difference_image()->display();
}

// draw motion detection data into the motion image
void ScreenOutput::draw_motion_data(Inputs *inputs, Results *results)
{
#ifndef NO_DISPLAY
    // temporary pointers to objects and observations to draw
    ListNode<TrackedObject> *object;
    ListNode<Region> *region;

    frame_id_t motion_image_frame_id;

    // draw moving regions into motion image
    if ((show_motion_images) && (draw_regions))
    {
	results->get_motion_image()->draw_in_image();
	motion_image_frame_id = results->get_motion_image()->get_frame_id();

#ifdef USE_GL
	if (results->get_motion_image()->get_image_type() == GREY8)
	    color(127);
	else
	    RGBcolor(127,127,127);
#endif	
	
	// for each object in the results:
	for (object = results->get_tracked_objects()->start();
	     object != NULL; object = object->next)
	{
	    // if object is visible then draw all measured regions in the object:
	    
	    for (region = object->dat->regions->first;
		 region != NULL; region = region->next)
	    {
		if ((region->dat->source == MEASUREMENT) &&
		    (region->dat->frame_last_detected == motion_image_frame_id))
		    region->dat->draw_box();
	    }
	}
    }
    
#ifdef DEBUG
    gflush();
#endif
#endif   // #ifndef NO_DISPLAY
}


// draw tracking results into respective images
void ScreenOutput::draw_results(Inputs *inputs, Results *results, frame_id_t min_draw_age)
{
#ifndef NO_DISPLAY
    // temporary pointers to objects and observations to draw
    ListNode<TrackedObject> *object;
    
    //  1 - draw tracked objects into the video image
    if (show_video_images)
    {
	inputs->get_video_image()->draw_in_image();
	
	// for each object in the results:
	for (object = results->get_tracked_objects()->start();
	     object != NULL; object = object->next)
	{
#ifdef USE_GL
	    if (inputs->get_video_image()->get_image_type() == GREY8)  // grey image, cmode
		color(127);
	    else
		Image::set_colour(object->dat->id);  // set colour according to id
	    
	    if (object->dat->is_visible)
		linewidth(3);
	    else
		linewidth(1);
#endif

	    if (draw_regions)
	    {
		//  2a - draw regions into video image
		object->dat->regions->draw_boxes(min_draw_age);
	    }
		
	    if (draw_features)
	    {
		//  2b - draw features into video image
		object->dat->features->draw();  // NB min_draw_age not supported now (no tracking)
	    }
	    
	    if (draw_profiles)
            {
                object->dat->profiles->draw(min_draw_age);
            }   	    
	    
	    // drawing features sets the colour, so reset:
#ifdef USE_GL
	    if (inputs->get_video_image()->get_image_type() == GREY8)  // grey image, cmode
		color(127);
	    else
		Image::set_colour(object->dat->id);  // set colour according to id
	    
	    if (object->dat->is_visible)
		linewidth(3);
	    else
		linewidth(1);
#endif
	}
    }
    
    //  2 - draw a label for each tracked object, re-setting colour first
    if (draw_label)
    {
	if (show_video_images)
	    inputs->get_video_image()->draw_in_image();
	else
	    if (show_motion_images)
		results->get_motion_image()->draw_in_image();
	    else
	    {
		// we might not have an image so drawing might fail
		return;
	    }
	
	char label[64];
	
	// for each object in the results:
	for (object = results->get_tracked_objects()->start();
	     object != NULL; object = object->next)
	{
#if 0	
	    // set colour
	    if (getplanes() == 8)   // CMap (grey?) image  (fi motion image)
		color(127);
	    else
		if (getplanes() == 24)      // RGB mode  (fi video image)
		    Image::set_colour(object->dat->id);  // set colour according to id
#endif
	    
#ifdef USE_GL
	    if (inputs->get_video_image()->get_image_type() == GREY8)  // grey image, cmode
		color(127);
	    else
		Image::set_colour(object->dat->id);  // set colour according to id
#endif
	    
	    if (object->dat->regions->no_items > 0)   // expect ``true''
		cmov2(object->dat->regions->first->dat->xlo,
		      MAX(0,object->dat->regions->first->dat->ylo - 12));
	    else
		if (object->dat->profiles->no_items > 0)   // expect ``true''
		    cmov2(object->dat->profiles->first->dat->xlo,
			  MAX(0,object->dat->profiles->first->dat->ylo - 12));
		else
		    continue;
	    
	    if (object->dat->profiles->no_items == 1)
	    {
		// assume this object is a person and call it that
		sprintf(label,"person %i",object->dat->id);
	    }
	    else
		if (object->dat->profiles->no_items > 1)
		{
		    // assume this object is a group and call it that
		    sprintf(label,"group %i",object->dat->id);
		}
		else
		{
		    // call this object an object
		    sprintf(label,"object %i",object->dat->id);
		}
	    charstr(label);   // output text, still in the same colour as the rest
	}
    }
    
#ifdef DEBUG
    gflush();
#endif
#endif   // #ifndef NO_DISPLAY
}


ScreenOutput::ScreenOutput(ConfigurationManager *configuration_manager)
{    
#ifndef NO_DISPLAY
    deflinestyle(1, 0xff00);
    deflinestyle(2,0xf0f0);  // define dashed line for drawing special objects
#endif   // #ifndef NO_DISPLAY
    
    // draw parameters for HumanFeatures: let them be constant for now
    HumanFeatures::draw_head_search_area = true;
    HumanFeatures::draw_head_bbox = true;
    HumanFeatures::draw_head_centre = true;
    HumanFeatures::draw_shoulder_width = true;

    register_configuration_paramaters(configuration_manager);
}


void ScreenOutput::register_configuration_paramaters(ConfigurationManager *configuration_manager)
{    
    show_video_images =
	configuration_manager->register_bool("SHOW_VIDEO_IMAGES", true,
					     &show_video_images, false,
					     "ScreenOutput",
					     "Show the source video images?");
    
    show_motion_images = 
	configuration_manager->register_bool("SHOW_MOTION_IMAGES", true,
					     &show_motion_images, false,
					     "ScreenOutput",
					     "Show the thresholded and filtered motion detection images ?");
    
    show_background_images = 
	configuration_manager->register_bool("SHOW_BACKGROUND_IMAGES", false,
					     &show_background_images, false,
					     "ScreenOutput",
					     "Show the generated background images ?");
    
    show_difference_images = 
	configuration_manager->register_bool("SHOW_DIFFERENCE_IMAGES", false,
					     &show_difference_images, false,
					     "ScreenOutput",
					     "Show the differenced images foreground-background ?");
    
    show_thresholded_difference_images = 
	configuration_manager->register_bool("SHOW_THRESHOLDED_DIFF_IMAGES", false,
					     &show_thresholded_difference_images, false,
					     "ScreenOutput",
					     "Show the thresholded difference foreground-background ?");
    
    show_filtered_difference_images = 
	configuration_manager->register_bool("SHOW_FILTERED_DIFFERENCE_IMAGES", false,
					     &show_filtered_difference_images, false,
					     "ScreenOutput",
					     "Show the filtered difference images fore-background?");
    
    draw_regions = 
	configuration_manager->register_bool("DRAW_REGIONS", true,
					     &draw_regions, false,
					     "ScreenOutput",
					     "Draw tracked ?");
    
    draw_features = 
	configuration_manager->register_bool("DRAW_FEATURES", true,
					     &draw_features, false,
					     "ScreenOutput",
					     "Draw tracked ?");
    
    draw_profiles = 
	configuration_manager->register_bool("DRAW_PROFILES", true,
					     &draw_profiles, false,
					     "ScreenOutput",
					     "Draw tracked ?");
    
    draw_label = 
	configuration_manager->register_bool("DRAW_LABEL", true,
					     &draw_label, false,
					     "ScreenOutput",
					     "Draw tracked ?");
    
    
    
//      show_occlusion_images = 
//  	configuration_manager->register_bool("SHOW_OCCLUSION_IMAGES", false,
//  					     &show_occlusion_images, true,
//  					     "ActiveShapeTracker",
//  					     "Show occlusion images ?");
    
}

} // namespace ReadingPeopleTracker
