///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  RegionTracker.h                                                          //
//                                                                           //
//  This tracker class tracks regions from frame to frame                    //
//                                                                           //
//  Author    : Nils T Siebel (nts)                                          //
//  Created   : Mon Oct 22 11:21:21 BST 2001                                 //
//  Revision  : 0.0 of Mon Oct 22 11:21:21 BST 2001                          //
//  Copyright : The University of Reading                                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __REGION_TRACKER_H__
#define __REGION_TRACKER_H__

// include files
#include "BaseTracker.h"
#include "tracker_defines_types_and_helpers.h"

namespace ReadingPeopleTracker
{

// forward declarations
class Region;
class MotionDetector;

class RegionTracker : public BaseTracker
{
public:
    
    RegionTracker (Calibration *the_calibration,
		   MotionDetector *the_motion_detector,
		   char *config_filename);
    
    ~RegionTracker()
	{
	    // nothing
	};
    
    // use inputs and current/previous results to obtain and store new results
    void process_frame(Inputs *inputs,
		       Results *results,
		       unsigned int max_objects = 32);
    
    // post processing: clean up tracks etc in results
    void post_process_frame(Inputs *inputs,
			    Results *results);
    
private:
    
    // configuration variables
    
    realno max_merge_difference;
    unsigned int max_match_difference;
    frame_id_t static_count_incorporate;    
    
    ConfigurationManager configuration;

    // we need the associated MotionDetector for MultiBackground features
    MotionDetector *motion_detector;
    
    /////  differences between regions, tags whether objects were matched
    realno region_diff[1024][1024];
    bool matched_tag [1024];
    
    void register_configuration_parameters();
    
    void predict_old_objects(Results *previous_results);
    void track_old_objects(Inputs *inputs, Results *results);
    void detect_new_objects(Inputs *inputs, Results *results);
    
    void calculate_region_differences(Results *results);
    void split_and_merge_regions(Results *results);
    void match_regions_in_objects(Inputs *inputs, Results *results);
    
private:
    // private helpers
    // calculate a difference measure between two regions, considering positions as well as sizes
    realno region_difference(const Region *r1, const Region *r2);
    
    // calculate a distance measure between two regions, considering positions only
    realno region_distance(const Region *r1, const Region *r2,
			   int *res_hdist = NULL, int *res_vdist = NULL);
};

} // namespace ReadingPeopleTracker

#endif
