/***************************************************************
 * C - C++ Header
 *
 * File : 	OcclusionImage.h
 *
 * Module :	OcclusionImage
 *
 * Author : 	A M Baumberg
 *
 * Creation Date : Wed May 25 15:36:16 1994 
 *
 * Comments : 	a simple 2D occlusion handler without depth 
 *		ordering
 *
 ***************************************************************/


#ifndef __OCCLUSION_IMAGE_H__
#define __OCCLUSION_IMAGE_H__

#include "OcclusionHandler.h"
#include "Grey8Image.h"
#include "tracker_defines_types_and_helpers.h" // for object_id_t

namespace ReadingPeopleTracker
{

class Profile;

class OcclusionImage : public OcclusionHandler, public Grey8Image
{
private:
    
    unsigned char curr_id;
    unsigned int big_width, big_height;
    unsigned int resample_shift;
    
public:
    
    OcclusionImage(unsigned int w, unsigned int h,
		   unsigned int the_resample_shift = 0);
    
    OcclusionImage(Grey8Image *the_occlusion_image);
    
    void mark_rect(Profile *prf, object_id_t object_id);
    
    void setup_occlusion_map(object_id_t object_id);

    bool is_occlusion(const int &x, const int &y) const;
    bool is_off_image(const int &x, const int &y) const;
    
};

} // namespace ReadingPeopleTracker

#endif
