/***************************************************************
 * C++ source
 *
 * File : 	OcclusionImage.cc
 *
 * Module :	OcclusionImage
 *
 * Author : 	A M Baumberg
 *
 * Creation Date : Wed May 25 15:41:40 1994 
 *
 * Comments : 	
 *
 ***************************************************************/


#include "OcclusionImage.h"
#include "Profile.h"

namespace ReadingPeopleTracker
{

OcclusionImage::OcclusionImage(unsigned int w, unsigned int h,
			       unsigned int the_resample_shift) :
    Grey8Image(w >> the_resample_shift, h >> the_resample_shift) 
{
    big_width = w;
    big_height = h;
    resample_shift = the_resample_shift;
}

OcclusionImage::OcclusionImage(Grey8Image *the_occlusion_image) :
    Grey8Image(*the_occlusion_image)
{
    assert (the_occlusion_image != NULL);
    
    big_width = the_occlusion_image->get_width();
    big_height = the_occlusion_image->get_height();
    
    // no resampling
    resample_shift = 0;
}

void OcclusionImage::mark_rect(Profile *prf, object_id_t object_id)
{
    setup_occlusion_map(object_id);
    
    unsigned int xmin = prf->xlo >> resample_shift;
    unsigned int xmax = prf->xhi >> resample_shift;
    unsigned int ymin = prf->ylo >> resample_shift;
    unsigned int ymax = prf->yhi >> resample_shift;
    
    if (xmin < 0)
	xmin = 0;
    if (xmax >= get_width())
	xmax = get_width() - 1;
    if (ymin < 0)
	ymin = 0;
    if (ymax >= get_height())
	ymax = get_height() - 1;
    
    for (unsigned int y = ymin; y <= ymax; y++)
    {
	unsigned char *start_pnt = Image::get_pixel(xmin,y);
	unsigned char *end_pnt = Image::get_pixel(xmax,y);
	while (start_pnt <= end_pnt)
	{
	    if (*start_pnt == CLEAR_MARK)
		*start_pnt = curr_id;
	    else
		*start_pnt = MARK;
	    start_pnt++;
	}
    }
}

void OcclusionImage::setup_occlusion_map(object_id_t object_id)
{
    curr_id = object_id & 0xff;  // we use a Grey8Image for tagging, it has 8 bits
}

bool OcclusionImage::is_off_image(const int &x, const int &y) const
{
    
    if ((x >= big_width) || (x < 0) || (y < 0) || (y >= big_height))
	return true;
    
    return false;   
}


bool OcclusionImage::is_occlusion(const int &x, const int &y) const
{
    if (check_coords(x >> resample_shift, y >> resample_shift) == false)
	return false;
    
    register unsigned char pix = *get_pixel(x >> resample_shift, y >> resample_shift);
    
    if ((pix != curr_id) && (pix != '\0'))
	return true;

    return false;
}

} // namespace ReadingPeopleTracker
