/***************************************************************
 * C - C++ Header
 *
 * File : 	OcclusionHandler.h
 *
 * Module :	OcclusionHandler
 *
 * Author : 	A M Baumberg (CoMIR)
 *
 * Creation Date : Fri Aug  9 15:21:49 1996 
 *
 * Comments : 	base class to handle occlusion
 *
 ***************************************************************/


#ifndef __OCCLUSION_HANDLER_H__
#define __OCCLUSION_HANDLER_H__

#include <cassert>

#include "tracker_defines_types_and_helpers.h" // for object_id_t

namespace ReadingPeopleTracker
{

class Profile;

class OcclusionHandler
{
public:
    
    virtual void setup_occlusion_map(Profile *prf)
	{
	    bool this_has_been_redefined_ok = false;
	    assert (this_has_been_redefined_ok == true);  // do not use this one, redefine!
	}
    
    virtual void setup_occlusion_map(object_id_t object_id)  // for OcclusionImage
	{
	    bool this_has_been_redefined_ok = false;
	    assert (this_has_been_redefined_ok == true);  // do not use this one, redefine!
	}
    
    // return true if pixel is occluded by other object (with different object id)
    virtual bool is_occlusion(const int &x, const int &y) const = 0;
    
    // return true if pixel is not in image area
    virtual bool is_off_image(const int &x, const int &y) const = 0;
    
    // wrappers for realno arguments
    inline bool is_occlusion(const realno &x, const realno &y) const
	{
	    return is_occlusion((int) (x+.5), (int) (y+.5));
	}
    
    inline bool is_off_image(const realno &x, const realno &y) const
	{
	    return is_off_image((int) (x+.5), (int) (y+.5));
	}
    
    

};

} // namespace ReadingPeopleTracker

#endif


