///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  HumanFeatureTracker.h (structure copied from ActiveShapeTracker.h)    //
//                                                                           //
//  This tracker class tracks human features such as head etc                //
//                                                                           //
//  Author    : Nils T Siebel (nts)                                          //
//  Created   : Fri Apr  6 15:08:24 BST 2001                                 //
//  Revision  : 0.0 of Fri Apr  6 15:08:24 BST 2001                          //
//  Copyright : The University of Reading                                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __HUMAN_FEATURE_TRACKER_H__
#define __HUMAN_FEATURE_TRACKER_H__

#include "BaseTracker.h"
#include "tracker_defines_types_and_helpers.h"

namespace ReadingPeopleTracker
{

class Image;
class Region;
class HumanFeatures;
class HumanFeatureSet;

class HumanFeatureTracker : public BaseTracker
{
    friend class ConfigurationManager;
    friend class HumanFeatures;  // we have drawing parameters for them
    
private:

    Image *video_image;
    Image *motion_image;

    void register_configuration_parameters();

    // return value: number of heads/peaks in histogram
    unsigned int detect_heads(Region *region, HumanFeatureSet *head_set);
    unsigned int do_vertical_histogram(Image *region_image,
				       VerticalHistogram *result);
    
    // temporary data used by histogram.  stored here so we do not need to alloc often
    unsigned int stats[2048];  // FIXME: assumes moving region is not wider than this

public:
    
    HumanFeatureTracker(Calibration *the_calibration,
			char *config_filename);

    // use inputs and current/previous results to obtain and store new results
    void process_frame(Inputs *inputs,
		       Results *results,
		       unsigned int max_objects);
    
    // post processing: clean up tracks etc in results
    void post_process_frame(Inputs *inputs,
			    Results *results)
	{
	    // nothing
	}
    
private:
    
    void predict_old_objects(Results *previous_results);
    void track_old_objects(Inputs *inputs, Results *results);
    void detect_new_objects(Inputs *inputs, Results *results);
    
    void process_region(Region *new_region, HumanFeatureSet *result_set);    

    // drawing parameters
    bool draw_head_search_area;
    bool draw_in_colour;
    bool draw_head_bbox;
    bool draw_head_centre;
    bool draw_shoulder_width;
};

} // namespace ReadingPeopleTracker

#endif


