#ifndef __BASE_TRACKER_H__
#define __BASE_TRACKER_H__

#include "ConfigurationManager.h"

namespace ReadingPeopleTracker
{

// forward declarations
class ConfigurationManager;
class TrackedObjectSet;
class Inputs;
class Results;
class Calibration;

class BaseTracker  // abstract class
{
    friend class ConfigurationManager;
    
protected:
    ConfigurationManager configuration;
    
    realno MIN_HEIGHT_TO_WIDTH;
    realno MAX_HEIGHT_TO_WIDTH;
    
public:
    Calibration *calibration;    // Calibration class (or NULL)
    
    // configuration variables

    // for calibration: min/max/typical world height of a person in world
    //   coordinate units (for ADVISOR: cm)
    realno MIN_WORLD_HEIGHT;
    realno MAX_WORLD_HEIGHT;
    realno TYPICAL_WORLD_HEIGHT;

    unsigned int debug_level;
    unsigned int max_objects;
    bool use_xml_ids;
    
    //pure virtual functions
    virtual void predict_old_objects(Results *previous_results) = 0;
    virtual void track_old_objects(Inputs *inputs, Results *results) = 0;
    virtual void detect_new_objects(Inputs *inputs, Results *results) = 0;
    
    // use inputs and current/previous results to obtain and store new results
    virtual void process_frame(Inputs *inputs,
			       Results *results,
			       unsigned int max_objects = 32) = 0;
    
    // post processing: clean up tracks etc in results
    virtual void post_process_frame(Inputs *inputs,
				    Results *results) = 0;
    
    //constructor registers all common parameters with ConfigurationManager
    BaseTracker();

    ~BaseTracker()
	{
	    // nothing
	};

    // accessor
    unsigned int get_debug_level() const
	{
	    return debug_level;
	}
    

private:    
    void register_base_configuration_variables();
};

} // namespace ReadingPeopleTracker

#endif
