#include "BaseTracker.h"
#include "List.h"

namespace ReadingPeopleTracker
{

BaseTracker::BaseTracker()
{
    calibration = NULL;  // default to NULL.  Derived trackers should set it themselves

    register_base_configuration_variables();
}

void BaseTracker::register_base_configuration_variables()
{
    // average height of a person is around 1.7m
    MIN_WORLD_HEIGHT =
	configuration.register_real("MIN_WORLD_HEIGHT", 130,
				    &MIN_WORLD_HEIGHT,
				    false, "GroundPeopleTracker",
				    "Minimum accepted world height of a person (in cm)");
    
    MAX_WORLD_HEIGHT =
	configuration.register_real("MAX_WORLD_HEIGHT", 230,
				    &MAX_WORLD_HEIGHT,
				    false, "GroundPeopleTracker",
				    "Maximum accepted world height of a person (in cm)");
    
    TYPICAL_WORLD_HEIGHT = 
	configuration.register_real("TYPICAL_WORLD_HEIGHT", 170,
				    &TYPICAL_WORLD_HEIGHT,
				    false, "ActiveShapeTracker",
				    "The typical height of a person in ground \
plane units (eg 170 cm)");

    max_objects = 
	configuration.register_int("MAX_OBJECTS", 8,
				   (int *) &max_objects,  false,
				   "BaseTracker", 
				   "The maximum number of silhouettes to track");
    
    debug_level =
	configuration.register_int("DEBUG_LEVEL", 0,
				   (int *) &debug_level, false,
				   "BaseTracker",
				   "General debug level");
    
    use_xml_ids =
	configuration.register_bool("USE_XML_IDS", false,
				    &use_xml_ids,
				    false, "BaseTracker",
				    "Use region id's specified in xml?");
}

} // namespace ReadingPeopleTracker
