///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  ReadingPeopleTracker.cc (from TrackerManagementProgram.cc by pte && nts) //
//                                                                           //
//  The main() program for the Reading People Tracker                        //
//                                                                           //
//  Author    : Nils T Siebel (nts)                                          //
//  Created   : Tue Jan  8 11:12:38 GMT 2002                                 //
//  Revision  : 1.1 of Fri Jan 28 13:14:30 CET 2005                          //
//  Copyright : The University of Reading                                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <cstdio>
#include <getopt.h>
#include <pthread.h>

#include "PeopleTracker.h"
#include "ConfigurationManager.h"
#include "text_output.h"
#include "tracker_defines_types_and_helpers.h"

using namespace ReadingPeopleTracker;

static const char *ReadingPeopleTracker_Revision = "@(#) ReadingPeopleTracker.cc, rev 1.1 of Fri Jan 28 13:14:30 CET 2005, Author Nils T Siebel, Copyright (c) 2005 Nils T Siebel";


int main(int argc, char **argv)
{
    cinfo << endl
	  << " ReadingPeopleTracker  Version 1.28 " << endl
	  << " Main Authors: Adam Baumberg (1993-1998) and Nils T Siebel (2000-current). " << endl
	  << " Copyright: (c) 2003-2005 Nils T Siebel" << endl
	  << " Please see the file COPYRIGHT for details. " << endl
	  << endl;

    char *config_filename = NULL;
    int option;
     
    while ((option = getopt(argc, argv, "c:")) != EOF)
	switch(option)
	{
	case 'c':
	    config_filename = optarg;
	    break;
	    
        default:
	    cerror << "Usage: " << argv[0] << "-c  <top level configuration file> " << endl;
	    exit(1);
	}
    
    if (config_filename == NULL)
    {
	cerror << "Usage: " << argv[0] << "-c  <top level configuration file> " << endl;
	return 1;
    }
    
    // set up new PeopleTracker class
    PeopleTracker *people_tracker = new PeopleTracker(config_filename);
    
    // check sanity of PeopleTracker
    int status = people_tracker->get_state();
    
    if (status < 0)  // an error occured
    {
	cerr << argv[0] << ": Could not start People Tracker.  Error code "
	     << status << "." << endl;
	return 1;
    }    
    
    // start processing thread in PeopleTracker
    pthread_t people_tracker_thread = people_tracker->start_thread();

    // wait until PeopleTracker thread has finished
    pthread_join(people_tracker_thread, NULL);  // NULL for void **status means ignore return value

    cinfo << argv[0] << ": finished. " << endl;
    
    return 0;

}  //  end of main

// Local Variables:
// compile-command: "make ReadingPeopleTracker |& fgrep :"
// End:

