////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//  NagMatrix_test.cc                                                         //
//                                                                            //
//  Program with test cases for the NagMatrix class                           //
//                                                                            //
//  Author    : Xin Wang                                                      //
//  Created   : Tue Mar 26 14:04:13 GMT 2002                                  //
//  Revision  : 1.0 of Sun Mar 31 14:15:24 BST 2002                           //
//  Copyright : The University of Reading                                     //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

#include "NagVector.h"
#include "NagMatrix.h"

#include <iostream>

using namespace ReadingPeopleTracker;

static const char *NagMatrix_test_Revision = "@(#) NagMatrix_test.cc, rev 1.0 of Sun Mar 31 14:15:24 BST 2002, Author Xin Wang, Copyright (c) 2002 The University of Reading";

// individual test cases for these NagMatrix methods...
void test_invert();

void test_get_eigenvectors();

void test_get_eigensystem();

void test_QR_factorise();

void test_sv_decompose();

void test_solve_equations();


int main(int argc, char** argv)
{
    cout << endl << " Test Cases for the NagMatrix class " << endl << endl;
    
///////////////////   1 - NagMatrix::invert()
    
    test_invert();
    
///////////////////   2 - NagMatrix::get_eigenvectors() 
    
    test_get_eigenvectors(); 
    
///////////////////   3 - NagMatrix::get_eigenvectors()
    
    test_get_eigensystem();
    
///////////////////   4 - NagMatrix::QR_factorise()
    
    test_QR_factorise();
    
///////////////////   5 - NagMatrix::sv_decompose()
    
    test_sv_decompose();
    
///////////////////   6 - NagMatrix::solve_equations()
    
    test_solve_equations(); 
    
    return 0;
}


void test_invert()
{
    int i,j,N;
    
    N=5;
    
    cout << " 1 - NagMatrix::invert() " << endl << endl;
    
    NagMatrix A(N,N);
    
    for(i=0;i<N;i++)
	for(j=0;j<N;j++)
	    A.set (i,j, 0);
    
    for(i=0;i<N;i++)    
	A.set (i,i, 3);
    
    cout << "Matrix before inversion: " << endl;
    
    A.output();
    cout << endl;
    
    A.invert(A);                    
    
    cout << "Matrix after inversion: " << endl;
    
    A.output();
    cout << endl;
}


void test_get_eigenvectors()
{
    int i,j,N;
    
    N=5;
    
    cout << " 2 - NagMatrix::get_eigenvectors() " << endl << endl;
    
    NagMatrix A(N,N);
    NagVector w(N);
    
    for(i=0;i<N;i++)
	for(j=0;j<N;j++)
	    A.set (i,j, 1);
    
    cout << "Matrix before operation: " << endl;
    
    A.output();
    cout << endl;
    
    A.get_eigenvectors( A, w);    
    
    cout << "Eigenvectors " << endl;
    
    A.output();
    cout << endl;
    
    cout << "The eigenvalues: " << endl;
    
    for(i=0;i<N;i++)
    {
	cout << " eigenvalue #" << i << " is " << w[i] << endl;
    }
    
    cout << endl;
}


void test_get_eigensystem()
{
    int i,j,N;
    
    N=5;
    
    cout << " 3 - NagMatrix::get_eigensystem() " << endl << endl;
    
    NagMatrix A(N,N);
    NagMatrix B(N,N);
    NagVector w(N);
    NagVector v(N);
    
    for(i=0;i<N;i++)
	for(j=0;j<N;j++)
	    A.set (i,j, 1);
    
    cout << "Matrix before operation: " << endl;
    
    A.output();
    cout << endl;
    
    A.get_eigensystem(A,B,w,v);
    
    cout << "Eigenvectors " << endl;
    
    A.output();
    cout << endl;
    
    cout << "The eigenvalues: " << endl;
    
    for(i=0;i<N;i++)
    {
	cout << " eigenvalue #" << i << " is " << w[i] << endl;
    }
    
    cout << endl;
}


void test_QR_factorise()
{
    int i,j,N;
    
    N=5;
    
    cout << " 4 - NagMatrix::QR_factorise()" << endl << endl;
    
    NagMatrix A(N,N);
    
    for(i=0;i<N;i++)
	for(j=0;j<N;j++)
	    A.set (i,j, 1);
    
    for(i=0;i<N;i++)
	A.set (i,i, 2);
    
    cout << "Matrix before operation: " << endl;
    
    A.output();
    cout << endl;
    
    A.QR_factorise(A);
    
    cout << "QR_factorise()" << endl;
    
    A.output();
    cout << endl;
}



void test_sv_decompose()   
{
    int i,j,N;
    
    N=5;
    
    cout << " 5 - NagMatrix::sv_decompose()" << endl << endl;
    
    NagMatrix A(N,N);
    NagMatrix P(N,N);
    NagVector w(N);
    
    for(i=0;i<N;i++)
	for(j=0;j<N;j++)
	    A.set (i,j, 1);
    
    cout << "Matrix before operation: " << endl;
    
    A.output();
    cout << endl;
    
    A.sv_decompose(A,w,P);
    
    cout << "sv_decompose()" << endl;
    
    A.output();
    cout << endl;
    
    cout << "The singular values: " << endl;
    
    for(i=0;i<N;i++)
    {
	cout << " singular value #" << i << " is " << w[i] << endl;
    }   
    
    cout << endl;
}

void test_solve_equations()
{
    int i,j,N;
    
    N=3;
    
    cout << " 6 - NagMatrix::solve_equations()" << endl << endl;
    
    NagMatrix A(N,N);
    NagMatrix B(N,N);
    NagMatrix X(N,N);
    
    for(i=0;i<N;i++)
	for(j=0;j<N;j++)
	    A.set (i,j, 1);
    
    A.set(1,0,2);
    A.set(2,1,2);
    
    for(i=0;i<N;i++)
	for(j=0;j<N;j++)
	    B.set (i,j, 0);
    
    B.set(0,0,5);
    B.set(1,0,6);
    B.set(2,0,6);
    
    cout << "Matrix A : " << endl;
    
    A.output();
    cout << endl;
    
    cout << "Matrix B : " << endl;
    
    B.output();
    cout << endl;
    
    A.solve_equations(B, X);
    
    cout << "Matrix X after solve_equations()  (AX = B) : " << endl;
    
    X.output();
    cout << endl;
}

// Local Variables:
// compile-command: "make NagMatrix_test |& fgrep :"
// End:
