/*
 *   Point2 is a simple 2D realno point class
 * 
 */

#ifndef __POINT2_H__
#define __POINT2_H__

#include <math.h>
#include <iostream>

#include "realno.h"
#include "text_output.h" // for cdebug

namespace ReadingPeopleTracker
{

class Point2
{
public:
    
    realno x;
    realno y;
    
    Point2(const realno the_x, const realno the_y)
	{
	    x = the_x;
	    y = the_y; 
	}
    
    Point2()
	{
	    x = 0; 
	    y = 0;
	}
    
    realno length() const;
    
    realno length2() const;
    
    realno block_length() const;
    
    Point2 map(const realno ax, const realno ay) const;
    
    void normalise();
    
    // operators
    Point2& operator+=(const Point2 v);
    
    Point2& operator-=(const Point2 v);
    
    Point2& operator*=(const realno a);
    
    Point2& operator/=(const realno a);
    
};

Point2 operator-(Point2 u);

Point2 operator*(realno a, Point2 v);

Point2 operator*(Point2 v, realno a);

Point2 operator/(Point2 v, realno a);

Point2 operator+(Point2 u, Point2 v);

Point2 operator-(Point2 u, Point2 v);

realno operator*(Point2 u, Point2 v);

realno operator^(Point2 u, Point2 v);

bool operator==(Point2 p1, Point2 p2);

bool operator!=(Point2 p1, Point2 p2);

ostream& operator<<(ostream& out_strm, const Point2& pnt);

istream& operator>>(istream& in_strm, Point2& pnt);

} // namespace ReadingPeopleTracker

#endif
