/*
 *   Point2 is a simple 2D realno point class
 * 
 */

#include "Point2.h"

namespace ReadingPeopleTracker
{

realno Point2::length() const
{
    return sqrt(x*x + y*y);
}
realno Point2::length2() const
{
    return x*x + y*y;
}
realno Point2::block_length() const
{ 
    return fabs(x) + fabs(y); 
}
Point2 Point2::map(const realno ax, const realno ay) const
{
    return Point2(ax * x - ay  * y, ay * x + ax * y);
}

void Point2::normalise()
{
//     register realno len2 = length2();
//    
//     if (len2 > 1e-30)
//     {	
	register realno len = length();
	x /= len;
	y /= len;
//     }
}

// operators
Point2& Point2::operator+=(const Point2 v)
{ 
    x += v.x; y += v.y;
    return *this;
}
Point2& Point2::operator-=(const Point2 v)
{
    x -= v.x; y -= v.y;
    return *this;
}
Point2& Point2::operator*=(const realno a)
{
    x *= a; y *= a;
    return *this; 
}
Point2& Point2::operator/=(const realno a)
{
    x /= a; y /= a;
    return *this;
}

Point2 operator-(Point2 u)
{
    return Point2(-u.x, -u.y);
}

Point2 operator*(realno a, Point2 v)
{
    return Point2(a*v.x,a*v.y); 
}

Point2 operator*(Point2 v, realno a)
{
    return Point2(a*v.x,a*v.y);
}

Point2 operator/(Point2 v, realno a)
{
    return Point2(v.x/a,v.y/a);
}

Point2 operator+(Point2 u, Point2 v) 
{
    return Point2(u.x+v.x, u.y+v.y);
}

Point2 operator-(Point2 u, Point2 v)
{
    return Point2(u.x-v.x, u.y-v.y);
}

realno operator*(Point2 u, Point2 v)
{
    return u.x * v.x + u.y * v.y;
}

realno operator^(Point2 u, Point2 v)
{
    return u.x * v.y - u.y * v.x;
}

bool operator==(Point2 p1, Point2 p2)
{
    return (p1.x == p2.x) && (p1.y == p2.y);
}

bool operator!=(Point2 p1, Point2 p2)
{
    return (p1.x != p2.x) || (p1.y != p2.y);
}

ostream& operator<<(ostream& out_strm, const Point2& pnt)
{
    out_strm << "(" << pnt.x << "," << pnt.y << ")"; 
    return out_strm;
}

istream& operator>>(istream& in_strm, Point2& pnt)
{ 
    char dummy;
    in_strm >> dummy >> pnt.x >> dummy >> pnt.y >> dummy;
    return in_strm;
}

} // namespace ReadingPeopleTracker
