/***************************************************************************
 * C - C++ Header
 *
 * File : 	XanimStream.h
 *
 * Module :	XanimStream
 *
 * Author : 	A Baumberg
 *
 * Creation Date : Tue Sep 17 10:20:19 1996 
 *
 * Comments : 	
 *
 ***************************************************************************/

#ifndef __XanimStream_H__
#define __XanimStream_H__


/* include files */
#include "PnmStream.h"

namespace ReadingPeopleTracker
{

#define XANIM_COMMAND "/usr/bin/X11/xanim +q +O -Zr"

class XanimStream: public PnmStream
{
private:

  char *tmp_buffer;

public:

  XanimStream(char* file) : PnmStream()
  {
      tmp_buffer = new char[strlen(XANIM_COMMAND) + strlen(file) + 
			   strlen("safety zone")];
      sprintf(tmp_buffer ,"%s %s", XANIM_COMMAND, file);
      reopen_stream(tmp_buffer);
  }

  ~XanimStream() { delete tmp_buffer; }
};


/* member functions */


/* non-member functions */

} // namespace ReadingPeopleTracker

#endif
