/***************************************************************
 * C - C++ Header
 *
 * File : 	PnmStream.h
 *
 * Module :	PnmStream
 *
 * Author : 	A M Baumberg (CoMIR)
 *
 * Creation Date : Thu Jun 13 10:21:20 1996 
 *
 * Comments : 	connect to a Stream of PNM images 
 *
 ***************************************************************/


/* include files */

#ifndef __PNM_STREAM_H__
#define __PNM_STREAM_H__

#include "ImageSource.h"
#include "tracker_defines_types_and_helpers.h"   // for frame_id_t

namespace ReadingPeopleTracker
{

// PnmStream :
// Passed a unix command that will generate a stream of
// pnm's to stdout OR simply an input stream containing pnm's
// This class connects to the stream to generate
// images accessed using the get_next() function

// note the get_next() method is implemented
// in "PgmSource.cc"

class PnmStream : public ImageSource
{
protected:
    FILE *input_stream;
    
    frame_id_t current_frame_number;   // number of current image in stream (0,1,2...)

public:
    
    PnmStream(char *command = NULL) : ImageSource(NULL) 
	{
	    char mode = 'r';
	    if (command != NULL)
		input_stream = popen(command, &mode);
	    else
		input_stream = NULL;
	
	    ImageSource::source_type = IST_STREAM;
	}
    
    PnmStream(FILE *stream_in) : ImageSource(NULL)
	{
	    input_stream = stream_in;
	    
	    ImageSource::source_type = IST_STREAM;
	}
    
    void reopen_stream(char *command)
	{
	    char mode = 'r';
	    if (input_stream != NULL)
		pclose(input_stream);
	    input_stream = popen(command, &mode);
	}
    
    ~PnmStream()
	{
	    pclose(input_stream);
	}
    
    inline virtual Image *get_next()
	{
	    if (frame_count == 0) // first frame
		current_frame_number = 0;
	    else 
		current_frame_number++;
	    
	    frame_count++;

	    if ((input_stream == NULL) || (ferror(input_stream)) || (feof(input_stream)))
	    {
		current = NULL;
		return current;
	    }
	    
	    // get image from stream
	    current = read_pnm(input_stream, current);
	    
	    // set frame number etc.  Since input is from a stream there is no info
	    // available on frame number or time.  We simply
	    // assume starting time 0 at frame 0
	    current->set_frame_id(current_frame_number);
	    current->set_frame_time_in_ms((frame_time_t)
					  (current_frame_number * default_frame_time_in_ms));
	    
	    return current;
	}
};

} // namespace ReadingPeopleTracker



#endif
