/***************************************************************
 * C - C++ Header
 *
 * File : 	PnmSource :  an ImageSource interface to a set of pnm files
 *
 * Module :	PnmSource
 *
 * Author : 	A M Baumberg (CoMIR)  // completely re-implemented by nts 2001--2002
 *
 * Creation Date : Wed Jun 29 20:55:39 1994 
 *
 ***************************************************************/


#ifndef __PNM_SOURCE_H__
#define __PNM_SOURCE_H__

#include <cassert>

#include "ImageSource.h"
#include "NumberedFiles.h"
#include "tracker_defines_types_and_helpers.h" // for ImageType

namespace ReadingPeopleTracker
{

class PnmSource : public ImageSource, public NumberedFiles
{
private:
    
    char sys_command[32+256+16+64];  // "zcat /advisor/.../image0017.pnm.gz"
    bool compressed_input;    // whether we use compressed infiles (eg file000.ppm.gz)

    // dimensions and type of image.  expect usuable values after constructor is called.
    unsigned int xdim;
    unsigned int ydim;
    ImageType image_type;

    unsigned int max_skip_non_existing;
    bool skip_non_existing;


public:

    PnmSource(char *initial_frame,
	      bool the_skip_non_existing, unsigned int the_max_skip_non_existing);

    ~PnmSource()
	{
	    // nothing
	}

    // these are static so they can be used without instantiating this class
    static Image *read_pnm(char *filename, Image *res);
    static Image *read_pnm(FILE *infile, Image *res);

    virtual Image *get_next();
    
    // accessors 
    inline const char *get_current_filename() const
	{
	    return NumberedFiles::get_current_filename();
	}

    // these three will return sensible values after successful instantiation
    virtual unsigned int get_xdim() const
	{
	    return xdim;
	}
    virtual unsigned int get_ydim() const
	{
	    return ydim;
	}
    virtual ImageType get_image_type() const
	{
	    return image_type;
	}

private:
    // private helper

    static PnmFileType read_pnm_header(FILE *infile,
				       unsigned int *width, unsigned int *height);
    
};

} // namespace ReadingPeopleTracker

#endif


