/*
 * PipeSource.h
 *
 * repackages image processing methods as `PipeSource's
 *
 */

#ifndef __MISCSRC_H__
#define __MISCSRC_H__

#include "Image.h"
#include "ImageSource.h"
#include "tracker_defines_types_and_helpers.h"
#include "text_output.h"

// NB: we  `#include "PipeSourceFilters.h"'  at the end of this file
// NB: we  `#include "MedianFilterSource.h"'  at the end of this file
// NB: we  `#include "MultiBackgroundSource"'  at the end of this file

namespace ReadingPeopleTracker
{

/****** PipeSource *****/

class PipeSource : public ImageSource
{
protected:
    ImageSource *in;
    bool is_wrapper;
    
    virtual Image *recalc() 
	{
	    if (is_wrapper == false)
	    {
		cerror << " >>>>>    error in PipeSource (no recalc) <<<<< " << endl;
		abort();
	    }
	    
	    //// return current;
	    if (current == NULL)
		current = in->get_current();
	    
	    return current;
	}
    
public:
    Image *motion_mask;
    
    inline long display(long new_window = NULLWIN)
	{
	    return get_current()->display(new_window);
	}
    
    inline Image *refresh()
	{ 
	    if (get_current() == NULL)
		return NULL;
	    else
		return current = recalc();
	}
    
    inline virtual frame_id_t get_source_frame_id() const
	{
	    return in->get_source_frame_id();
	}
    
    inline virtual frame_time_t get_source_frame_time_in_ms() const
	{
	    return in->get_source_frame_time_in_ms();
	}
    
    inline virtual unsigned int get_xdim() const
	{
	    return in->get_xdim();
	}
    
    inline virtual unsigned int get_ydim() const
	{
	    return in->get_ydim();
	}
    
    inline ImageType get_image_type() const
	{
	    return in->get_image_type();
	}
    
    inline virtual Image *get_current()
	{
	    // match frame id to parent's frame id
	    if ((current != NULL) &&                             // we have a valid image
		(current->get_frame_id() == get_source_frame_id())) // and are up to date
		return current;
	    else
	    {
		in->get_current();                // recursive update as necessary
		current = recalc();
		// propagate frame id and frame time from original input
		current->set_frame_id(get_source_frame_id());
		current->set_frame_time_in_ms(get_source_frame_time_in_ms());
		return current;
	    }
	}
    
    inline virtual Image *get_next()
	{
	    assert(is_wrapper == false);  // I believe this is_wrapper implementation is flawed but not used.  checking...  nts
	    
	    frame_count++;
	    
	    if (is_wrapper) //if a PipeSource wrapper only then must get_next() directly
	    {
		current = in->get_next();
  	    }    
  	    else 
  		current = get_current();  //  automatically follow in's new frame_id
	    
	    return current; 
	}
    
    inline ImageSource *get_input_source()
	{
	    return in;
	}
    
    PipeSource(ImageSource *source, bool the_is_wrapper = false) : ImageSource(NULL)
	{
	    assert(source != NULL);
	    
	    is_wrapper = the_is_wrapper;
	    in = source;
	    motion_mask = NULL;
	}
    
    // use clean_up before deleting to avoid deleting the input ImageSource etc
    inline virtual void clean_up()
	{
	    in = NULL;
	}
    
    virtual void set_motion_mask(Image *img)
	{
	    motion_mask = img;
	}
    
    ~PipeSource()
	{
	    delete in;
	}
    
};

} // namespace ReadingPeopleTracker

////////     include PipeSourceFilters.h: many image filters                ////////

#include "PipeSourceFilters.h"

////////     include MedianFilterSource.h: temporal median filtering        ////////

#include "MedianFilterSource.h"

////////     include MultiBackgroundSource.h: multi-background modelling    ////////

#include "MultiBackgroundSource.h"

#endif
