///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  MovieStore.h                                                             //
//                                                                           //
//  This class stores a sequence of images in a number of formats (future)   //
//                                                                           //
//  Currently, only individual JPEG images can be written.                   //
//  This code is written with full colour images in mind (24/32-bit).        //
//                                                                           //
//  Author    : Nils T Siebel (nts)                                          //
//  Created   : Mon Oct 16 10:30:39 GMT 2000                                 //
//  Revision  : 1.0 of Fri Oct 27 10:33:15 GMT 2000                          //
//  Copyright : The University of Reading                                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


#ifndef __MOVIE_STORE_H__
#define __MOVIE_STORE_H__

// system includes
#include <cstdio>  // for FILE type

// the folloging is for for jpeglib (only)
#define HAVE_PROTOTYPES

extern "C"
{
#include <jpeglib.h>
}

// include files
#include "tracker_defines_types_and_helpers.h"   // for frame_id_t

namespace ReadingPeopleTracker
{

// forward declarations
class Image;

class MovieStore
{
public:
    
    MovieStore (MovieStoreFormat movieformat, char *moviefilename);
    ~MovieStore();
    
    bool add_a_frame(Image *new_frame);
    
    inline frame_id_t get_frame_no()
	{
	    return current_frame;
	}

    inline frame_id_t get_frame_count()
	{
	    return num_frames;
	}

protected:
    
    MovieStoreFormat format;

    bool individual_files;

    // for numbered files, what comes before and after the number
    char filename_base[256];
    char filename_ext[64];
    char filename[256+16+64];
    unsigned int filename_num_digits;  // for sprintf
    frame_id_t start_frame;    // number (named) of first frame to be written
    frame_id_t current_frame;  // number (named) of current frame
    
    frame_id_t num_frames;     // counting as we write them
    FILE *outfile;
    
    // image/file data
    int xdim;
    int ydim;
    int depth;
    unsigned char image_buffer[1600*1200*3];  // buffer for frame, converted for jpeg_* routines
    
    // JPEG stuff
    // j_compress_ptr jpeg_compression_info;
    jpeg_compress_struct jpeg_compression_info;
    jpeg_error_mgr jpeg_error_manager;
    JSAMPROW jpeg_row_pointer[1200];	// pointer to JSAMPLE row[s]
    unsigned int jpeg_row_stride;	// physical row width in image buffer

};

} // namespace ReadingPeopleTracker

#endif   // ifndef __MOVIESTORE_H__

