/*
 * MedianFilterSource.h
 *
 * median filter (over time) to extract background
 * 
 * defined as a PipeSource
 */

////
////  NB do not include this file directly.  We are included by PipeSource.h
////

#ifndef __MEDIAN_FILTER_SOURCE_H__
#define __MEDIAN_FILTER_SOURCE_H__

namespace ReadingPeopleTracker
{

class MedianFilterSource : public PipeSource
{
private:
    /* for grey images only the red field is used */
    Image *counts_red; 
    Image *counts_green;
    Image *counts_blue;
    Image *nearest;
    
public:
    // input_images -- the source of images
    // run_length	  -- the (temporal) window used for update
    // background_image -- optional starting estimate for background
    MedianFilterSource(ImageSource *input_images, unsigned int run_length = 20, 
		       Image *background_image = NULL);
    
    ~MedianFilterSource();
    
    Image *recalc();
    void restart();
    
private:

    // private helpers 
    
    // use byte mask, motion mask image
    void update_median(unsigned char *image, unsigned char *median,
		       unsigned char *nearest, unsigned char *counts,
		       unsigned char *enddat, int rl, unsigned char mask, 
		       unsigned char *motion, int mskip_h,
		       int mskip_v, int mwidth);
    // use byte mask 
    void update_median(unsigned char *image, unsigned char *median,
		       unsigned char *nearest, unsigned char *counts,
		       unsigned char *enddat, int rl, unsigned char mask);
    
    // no byte mask, use motion mask
    void update_median(unsigned char *image, unsigned char *median,
		       unsigned char *nearest, unsigned char *counts,
		       unsigned char *enddat, int rl,
		       unsigned char *motion, int mskip_h,
		       int mskip_v, int mwidth);
    
    // no byte mask, no motion mask
    void update_median(unsigned char *image, unsigned char *median,
		       unsigned char *nearest, unsigned char *counts,
		       unsigned char *enddat, int rl);
    
    

    unsigned int run_length;

    static const unsigned char ZERO; // = 128;    
    
};

} // namespace ReadingPeopleTracker

#endif
