/*
 * Kernel.h
 * 3x3 Kernel class
 * for image processing
 */

#ifndef __KERNEL_H__
#define __KERNEL_H__


namespace ReadingPeopleTracker
{

class Kernel 
{
 public:
  
  /* the Kernel is simply a 3x3 integer array */
  int coeff[3][3];

  /* along with some constructors */
  Kernel() { coeff[0][0] = coeff[0][1] = coeff[0][2] = coeff[1][0] = coeff[1][1]
	     = coeff[1][2] = coeff[2][0] = coeff[2][1] = coeff[2][2] = 0;}
  Kernel( int row1[3], int row2[3], int row3[3], bool by_row = true );
  Kernel( int data[9] , bool by_row  = true);
  Kernel(int d1,int d2, int d3, int d4, int d5, int d6, int d7, 
	       int d8, int d9, bool by_row = true);

};

Kernel operator+ (Kernel& K1 , Kernel& K2);
Kernel operator* (Kernel& K1, Kernel& K2);

const Kernel SOBELV_KER = Kernel(1,0,-1,2,0,-2,1,0,-1,true);
const Kernel SOBELH_KER = Kernel(1,0,-1,2,0,-2,1,0,-1,false);
const Kernel BLUR_KER = Kernel(1,1,1,1,1,1,1,1,1,true);

} // namespace ReadingPeopleTracker

#endif





