/*
 * Kernel.cc
 * 3x3 Kernel class
 * for image processing
 */


#include "Kernel.h"

namespace ReadingPeopleTracker
{

Kernel::Kernel( int row1[3], int row2[3], int row3[3], bool by_row )
{
  if (by_row)
    {
      coeff[0][0] = row1[0]; coeff[0][1] = row1[1]; coeff[0][2] = row1[2];      
      coeff[1][0] = row2[0]; coeff[1][1] = row2[1]; coeff[1][2] = row2[2];      
      coeff[2][0] = row3[0]; coeff[2][1] = row3[1]; coeff[2][2] = row3[2];
    }
  else
    {
      coeff[0][0] = row1[0]; coeff[1][0] = row1[1]; coeff[2][0] = row1[2];      
      coeff[0][1] = row2[0]; coeff[1][1] = row2[1]; coeff[2][1] = row2[2];      
      coeff[0][2] = row3[0]; coeff[1][2] = row3[1]; coeff[2][2] = row3[2];
    }
}

Kernel::Kernel(int data[9] , bool by_row)
{
  if (by_row)
    {
      coeff[0][0] = data[0]; coeff[0][1] = data[1]; coeff[0][2] = data[2];      
      coeff[1][0] = data[3]; coeff[1][1] = data[4]; coeff[1][2] = data[5];      
      coeff[2][0] = data[6]; coeff[2][1] = data[7]; coeff[2][2] = data[8];
    }
  else
    {
      coeff[0][0] = data[0]; coeff[0][1] = data[3]; coeff[0][2] = data[6];      
      coeff[1][0] = data[1]; coeff[1][1] = data[4]; coeff[1][2] = data[7];      
      coeff[2][0] = data[2]; coeff[2][1] = data[5]; coeff[2][2] = data[8];
    }
}

Kernel::Kernel(int d1,int d2, int d3, int d4, int d5, int d6, int d7, 
	       int d8, int d9, bool by_row)
{
  if (by_row)
    {
      coeff[0][0] = d1; coeff[0][1] = d2; coeff[0][2] = d3;      
      coeff[1][0] = d4; coeff[1][1] = d5; coeff[1][2] = d6;      
      coeff[2][0] = d7; coeff[2][1] = d8; coeff[2][2] = d9;
    }
  else
    {
      coeff[0][0] = d1; coeff[0][1] = d4; coeff[0][2] = d7;      
      coeff[1][0] = d2; coeff[1][1] = d5; coeff[1][2] = d8;      
      coeff[2][0] = d3; coeff[2][1] = d6; coeff[2][2] = d9;
    }
}
  
Kernel operator+ (Kernel& K1 , Kernel& K2)
{
  Kernel sum;
  for (int i = 0; i < 3; i++)
    {
      for (int j = 0; j < 3; j++)
	{
	  sum.coeff[i][j] = K1.coeff[i][j] + K2.coeff[i][j];
	}
    }
  return sum;
}

Kernel operator* (Kernel& K1, Kernel& K2)
{
  Kernel sum;
  for (int i = 0; i < 3; i++)
    {
      for (int k = 0; k < 3; k++)
	{
	  sum.coeff[i][k] = 0;
	  for (int j = 0; j < 2; j++)
	    {
	      sum.coeff[i][k] += K1.coeff[i][j] * K2.coeff[j][k];
	    }
	}
    }
  return sum;
}

} // namespace ReadingPeopleTracker
