///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  JPEGSource.h  (structure copied from MpegStream.h by Adam Baumberg)      //
//                (based on our new (JPEG) MovieStore and IJG's example.c)   //
//                                                                           //
//  This class reads individual, numbered JPEG files as an ImageSource       //
//                                                                           //
//  This code is written with full colour images in mind (24/32-bit).        //
//                                                                           //
//  Author    : Nils T Siebel (nts)                                          //
//  Created   : Thu Oct 26 18:52:41 GMT 2000                                 //
//  Revision  : 1.5 of Tue Jul 24 15:55:06 BST 2001                          //
//  Copyright : The University of Reading                                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __JPEG_SOURCE_H__
#define __JPEG_SOURCE_H__

#include "ImageSource.h"
#include "tracker_defines_types_and_helpers.h" // for ImageType

// for some reason, we have to include jpeglib here and not in .cc

#ifdef __cplusplus
extern "C"
{
#include <jpeglib.h>   // this is the IJG's libjpeg.
}
#else
#include <jpeglib.h>   // this is the IJG's libjpeg.
#endif // __cplusplus

namespace ReadingPeopleTracker
{

// JPEGSource : an ImageSource interface to a set of JPEG files

class JPEGSource : public ImageSource
{
protected:
    
    // for numbered files, what comes before and after the number
    char JPEGfilename_base[256];
    char JPEGfilename_ext[64];
    char JPEGfilename[256+16+64];
    unsigned int JPEGfilename_num_digits;    // number of digits number is padded to in sprintf
    unsigned int JPEGstart_frame_number;     // number of first JFIF file
    unsigned int JPEGcurrent_frame_number;   // number of current JFIF file
    
    unsigned int JPEGnum_frames;     // counting as we read them
    FILE *JPEGinfile;
    
    // image/file data
    unsigned int JPEGxdim;
    unsigned int JPEGydim;
    unsigned char JPEGimage_buffer[1600*1200*3];  // buffer for frame, written to by jpeg_* routines
    unsigned int row_stride;	     // physical row width in output buffer
    JSAMPROW row_pointer[1200];	     // pointer to JSAMPLE row[s] in output buffer
    
    bool is_grey_image;              // true: use GREY8, false: use RGB32
    
    jpeg_decompress_struct cinfo;
    jpeg_error_mgr jerr;
    
    unsigned int max_skip_non_existing;
    bool skip_non_existing;
    
    unsigned int header_warning_count;  // count error messages in order to limit them
    
public:
    
    // constructor, desctructor
    JPEGSource(char *first_filename,
	       bool the_skip_non_existing, unsigned int the_max_skip_non_existing);
    ~JPEGSource();
    
    virtual Image *get_next();    

    virtual unsigned int get_xdim() const
	{
	    return JPEGxdim;
	}
    
    virtual unsigned int get_ydim() const
	{
	    return JPEGydim;
	}
    
    inline char *get_file_name()
	{
	    return JPEGfilename;
	}
    
    virtual ImageType get_image_type() const
	{
	    // we only support two formats
	    if (is_grey_image)
		return GREY8;
	    
	    return RGB32;
	}
    
};

} // namespace ReadingPeopleTracker

#endif

