/*
 * ImageSource.cc
 *
 * a general image source class
 *
 */

#include "ImageSource.h"

namespace ReadingPeopleTracker
{

long ImageSource::display(long window)
{
#ifdef NO_DISPLAY
    return NULLWIN;
#else
    if (get_current() == NULL)
	return NULLWIN;
    
    if (imgsrc_window_title[0] != 0)
	current->set_title(imgsrc_window_title);  // overriding Image::window_title
    
    return current->display(window);
#endif  //ifndef NO_DISPLAY
}

} // namespace ReadingPeopleTracker
