//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//  IEEE1394Source.h                                                        //
//                                                                          //
//  This class controls the Image Source from the camera.                   //
//  It decodes DV encoded frames from the IEEE1394Adaptor.                  // 
//                                                                          //
//  Author     : Sarah Laval (sl) supervised by Nils T Siebel (nts)         //
//  Created    : Mon Jun 17 17:32:34 BST 2002                               //
//  Copyright  : The University of Reading                                  //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef __IEEE_1394_SOURCE_H__
#define __IEEE_1394_SOURCE_H__


#include <dv.h>
#include <sys/time.h>

#include "ImageSource.h"
#include "IEEE1394Adaptor.h"

#include "text_output.h"  // for cerror, cdebug ...

namespace ReadingPeopleTracker
{

// IEEE1394Source : an Image Source interface to hold frames from the camera

class IEEE1394Source : public ImageSource
{
private :
  
    // private methods 
    void acquire_DV_frame();
    void DV_decode();
    int decode_image(Image *image);
  
    // buffer for the decompressed frame, written to by libdv routines
    unsigned char decompressed_image_data[1600*1200*3];

    // frame data
    unsigned int xdim;
    unsigned int ydim;
    frame_id_t frame_count;
    struct timeval *time;

    // decoding data
    dv_decoder_t *decoder;
  
    // IEEE1394 data
    IEEE1394Adaptor *Adaptor;
    DV_encoded_frame_t *DV_encoded_data;

public :

    // constructor, destructor
    IEEE1394Source(int);
    ~IEEE1394Source();
    
    virtual Image *get_next();
 
    // access functions
    virtual unsigned int get_xdim() const
	{
	   return 720; // this is the DV standard
 
	}

    virtual unsigned int get_ydim() const
	{
	    return 576; // this is the DV standard
	}
	
    virtual ImageType get_image_type() const
	{
	    return RGB32;  // we only do RGB32
	}
    
};

} // namespace ReadingPeopleTracker

#endif


