//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//  IEEE1394Adaptor.h                                                       //
//                                                                          //
//  This class maintains a connection to the DV camcorder.                  //
//  It reads DV encoded frames from the camcorder.                          //
//                                                                          //
//  Author     : Sarah Laval (sl) supervised by Nils T Siebel (nts)         //
//  Created    : Mon Jun 17 17:32:34 BST 2002                               //
//  Copyright  : The University of Reading                                  //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef __IEEE_1394_ADAPTOR_H__
#define __IEEE_1394_ADAPTOR_H__

#include <raw1394.h>
#include <rom1394.h>
#include <avc1394.h>
#include <avc1394_vcr.h>

#include "text_output.h"  //  for cerror, cdebug, cinfo

using namespace std;

namespace ReadingPeopleTracker
{

typedef struct  // holds one frame of encoded DV data
{
    unsigned int buffer_size_used;
    //quantity of data already stored in the 144000-byte buffer
     
    unsigned char current_frame[144000 + 640];  
    // 144000 bytes plus safety margin
} DV_encoded_frame_t;


// IEEE1394Adaptor : an interface to dial with the device

class IEEE1394Adaptor 
{
private :

    // device data
    raw1394handle_t handle;
    iso_handler_t old_iso_handler;
    rom1394_directory rom_dir;
    int port;
    int num_nodes;
    int channel;
    bool is_dataflow;

    
    // frame data
    size_t packet_length;
    static bool dv_frame_has_started;
    char *timecode;
    
    // buffer DV for encoded frame
    static DV_encoded_frame_t buffer;
    
public :

     // constructor, destructor
    IEEE1394Adaptor();
    ~IEEE1394Adaptor();

    //methods
    void connect_1394();
    void disconnect_1394(); 
    void find_camera();
    void set_iso_handler();
    void start_dataflow();
    void stop_dataflow();
    DV_encoded_frame_t *capture_frame(int);

    //converting functions
    static int frame_iso_handler(raw1394handle_t, int , size_t ,quadlet_t *);
    static int frame_reset_handler(raw1394handle_t, unsigned int);
 
    //access functions
    const int get_channel() const
	{
	    return channel;
	}

};

} // namespace ReadingPeopleTracker

#endif


