/***************************************************************
 * C - C++ Header
 *
 * File : 	GreyMap.h
 *
 * Module :	GreyMap
 *
 * Author : 	A M Baumberg (CoMIR)
 *
 * Creation Date : Mon Jun 17 10:45:07 1996 
 *
 * Comments : 	an intensity correction map
 *
 ***************************************************************/

#ifndef __GREY_MAP_H__
#define __GREY_MAP_H__

#include "realno.h"

namespace ReadingPeopleTracker
{

typedef unsigned char BaseGreyMap[256];
typedef unsigned char *PntGreyMap;

// gamma correction 
// Result  = 255 * [(Intensity / 255)^(1.0 / gamma)]

class GammaCorrectMap 
{
protected:
    
    BaseGreyMap data;
    
public:
    
    GammaCorrectMap(realno gamma_val);
    
    operator PntGreyMap()
	{
	    return &data[0];
	}
};

} // namespace ReadingPeopleTracker

#endif
