/*
This source file is the copyright property of the University of Leeds
('The University').

Permission to use, copy, modify, and distribute this source file for
educational, research, and not-for-profit purposes, without fee and
without a signed licensing agreement, is hereby granted, provided that
the above copyright notice, this paragraph and the following three
paragraphs appear in all copies, modifications, and distributions.

In no event shall The University be liable to any party for direct,
indirect, special, incidental or consequential damages, including lost
profits, arising out of the use of this software and its documentation.

The software is provided without warranty. The University has no obligation
to provide maintenance, support, updates, enhancements, or modifications.

This software was written by Adam Baumberg, Vision Group,
School of Computer Studies, University of Leeds, U.K. The code and use
thereof should be attributed to the author where appropriate (including
demonstrations which rely on it's use).
*/
/***************************************************************
 * C++ source
 *
 * File : 	GreyMap.cc
 *
 * Module :	GreyMap
 *
 * Author : 	A M Baumberg (CoMIR)
 *
 * Creation Date : Mon Jun 17 10:48:25 1996 
 *
 * Comments : 	
 *
 ***************************************************************/


/* include files */

#include "GreyMap.h"
#include <math.h>

namespace ReadingPeopleTracker
{

GammaCorrectMap::GammaCorrectMap(realno gamma_val)
{
  realno inv_gamma = 1.0 / gamma_val;
  for (int c = 0; c < 256; c++)
    {
      realno pix = c / 255.0;
      pix = 0.5 + 255.0 * pow(pix, inv_gamma);
      data[c] = (unsigned char) pix;
    }
}

} // namespace ReadingPeopleTracker
