/*
 * Image.h
 * general image class
 * not fully implemented yet
 *
 * author : A M Baumberg
 */

#ifndef __GREY8_IMAGE_H__
#define __GREY8_IMAGE_H__

#include "Image.h"
#include "RGB32Image.h"
#include <math.h>
#include <stdlib.h>

namespace ReadingPeopleTracker
{

class Grey8Image : public Image
{
private:
    
    unsigned char Grey8_draw_colour;
    
public:
    
    Grey8Image(unsigned int the_width, unsigned int the_height,
	       frame_id_t the_frame_id = 0, frame_time_t the_frame_time_in_ms = 0,
	       unsigned char *the_data = NULL) 
	: Image(the_width, the_height,
		the_frame_id, the_frame_time_in_ms,
		1, the_data)
	{
	    image_type  = GREY8;
	    Grey8_draw_colour = MARK;
	}

    // copy constructor
    Grey8Image(const Grey8Image &other_image)
	: Image(other_image.get_width(), other_image.get_height(),
		0, 0, 1, NULL)         // these will be set below...
	{
	    image_type = GREY8;
	    other_image.copy(this);    // this will do the actual copying...
	}

    Grey8Image(char *pgmfile);
    ~Grey8Image();
    
    // redefined functions from Image class
    void virtual_display();

    Image *copy (Image *res = NULL) const;

    Image *copy_type(unsigned int w = 0, unsigned int h = 0)
	{ 
	    if (w == 0)
		w = width;
	    if (h == 0)
		h = height;
	    return new Grey8Image(w, h);
	}

    Image *virtual_copy(Image *res = NULL) const
	{
	    if (res == NULL)
		return new Grey8Image(width, height, frame_id, frame_time_in_ms, data);
	    else 
	    {
		// just copy over our variables
		memcpy(res, this, sizeof(*this));
		res->own_data = false;
		return res;
	    }
	}
    
    Image *resample (unsigned int xstep, unsigned int ystep, Image *r = NULL);
    RGB32Image *rgb_read_image(RGB32Image *res = NULL);
    
    Image *convolve (Kernel k, Image *r = NULL);
    
    Image *fcombine(Image *image2, int (*func) (void*, void *), Image *r
		    = NULL);
    Image *neighbour_order(unsigned int n, Image *r = NULL);
    Image *minimum(Image *r = NULL);
    Image *maximum(Image *r = NULL);
    Image *fmed (Image *r = NULL);
    Image *sobel(unsigned int threshold, Image *r = NULL);
    Image *sobel(Image *r = NULL);
    Image *threshold (unsigned int threshold, Image *r = NULL,
		      unsigned int *no_marked = NULL);
    
    Image *blur(Image *res = NULL);
    Image *half_blur( Image *r = NULL);
    Image *mask(Image *mask, Image *r = NULL);
    // this one copied from BWImage --- nts Feb 26, 2001
    Image *fix_holes(int gapsize, Image *r = NULL);
    
    Image *extract_subimage(int xlo, int xhi, int ylo, int yhi,
			    Image *r = NULL);
    
    Image *difference(Image *i2, realno threshold, Image *r = NULL);
    Image *difference(Image *i2, Image *r = NULL);
    Image *simple_difference(Image *image2, realno threshold, 
			     unsigned int *no_marked, Image *r = NULL);
    
    //Image *flip_vertically(Image *r = NULL);
    long display(long glw = NULLWIN);
    
    Image *diff_stats(Image *i2, realno &mean, realno &variance, 
		      Image *r = NULL);
    
    Image *image_blend(Image *i2, int a, int b, Image *r = NULL);
    Image *map_intensities(PntGreyMap gmap, Image *r = NULL);
    
    void clear_border();
    void draw_rectangle(int xmin, int xmax, int ymin, int ymax, int val); 
    Image *transform(int centre_x, int centre_y, realno angle,
		     realno scale, Image *res = NULL);
    
    
    /* extra Grey8  specific functions */

    Grey8Image *invert(Grey8Image *res = NULL);   // simpy invert (bitwise negate) image
    
    /* compress a black & white image as returned from difference */
    Image *b_w_compress(Image *r = NULL);
    Image *b_w_uncompress(Image *r = NULL);
    
    /* return fraction of marked pixels in image*/
    realno get_marked_fraction();
    
    /* save as ppm */
    void save_pnm(char *filename = NULL);
    
    /* convert to RGB32 */
    Image *to_rgb(Image *r);
    Image *to_rgb(RGB32pixel *color_map, Image *res);
    
    void median_img_array(Image **img_array, int array_size);
    
    void set_draw_colour(unsigned char red, unsigned char green,
			 unsigned char blue);
    void set_draw_colour(unsigned char grey_value);
    
    void draw_horizontal(unsigned int y, unsigned int xl, unsigned int xr, bool dotted = false);
    void draw_vertical(unsigned int x, unsigned int yl, unsigned int yu, bool dotted = false);
    
    void plot_pixel(unsigned int x, unsigned int y);

    
private:
    // private helpers
    static int compar_char(const void *c1, const void *c2);
    static unsigned char get_mid (unsigned char &a, 
	   		          unsigned char &b,
			          unsigned char &c);

    static void get_detail(unsigned char *g1, unsigned char *g2,
	       	           unsigned char *r, int &width);
    static const int BOX_SIZE;

#ifndef NO_DISPLAY
#ifndef USE_GL
private:
    // static member variables and helpers
    static Colormap cmap;
    static int no_using_cmap;
    static unsigned char pixel;
    static unsigned long reverse_cmap[256];
    static int no_grey_cells;

    static void setup_greymap(Display *mydisplay, int screen, Window mywindow);    
#endif   // #ifndef USE_GL
#endif   // #ifndef NO_DISPLAY

};

} // namespace ReadingPeopleTracker

#endif
