ifndef GENERIC_RULES
GENERIC_RULES = 1  

# Common Rules

$(LIBNAME): $(OBJS)
	ar cru $(LIBNAME) $(OBJS) 
	ranlib $(LIBNAME)
	chmod g+r $(LIBNAME)

$(LIBDEBUG): $(OBJS)
	ar cru $(LIBDEBUG) $(OBJS)
	ranlib $(LIBNAME)
	chmod g+r $(LIBDEBUG)


# our depend for some reason names files name..o etc so we have to fix them afterwards...
depend: $(SRCS) $(TESTSRCS) $(HDRS)
	if [ ! -f .depend ]; then touch .depend; fi
	cd ..; makedepend -- $(C++FLAGS) $(CDEBUG) $(DEFINES) $(GENERIC_INCLUDES) -I/usr/include/g++ -- -f $(OS)/.depend $(SRCS1) $(TESTSRCS)
	tcsh -cf "echo ',s/\.\.o/.o/g\nw' | ed -s .depend >& /dev/null; true"

clean:
	(rm -f $(OBJS) $(LIBNAME) $(LIBDEBUG); )

# Common implicit rules specification (calls to Check out avoided (lastline) )

.SUFFIXES:

% : ../%.cc
	mkdir -p $(BIN_HOME)
	${C++} $(C++FLAGS) $< ${GENERIC_LDFLAGS} ${LDFLAGS} $(CDEBUG) -o $(BIN_HOME)/$@
	chmod g=rx,o= $(BIN_HOME)/$@
%.o : ../%.cc
	${C++} $(C++FLAGS) $(CDEBUG) -c $<
%.s : %.cc
	${C++} ${C++FLAGS} -S $<
%.i : %.cc
	${C++} ${C++FLAGS} -E $< > $*.i
%.c : %.cc
	${C++} -F -.c $(C++FLAGS) $< 
% : ../RCS/%,v

endif

