///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  Stack.h      Stack class which holds unsigned char* elements             //
//                                                                           //
//  Author    : Nils T Siebel (nts)                                          //
//  Created   : Mon Jan 21 21:46:48 GMT 2002                                 //
//  Revision  : 1.0 of Mon Jan 21 22:32:49 GMT 2002                          //
//  Copyright : The University of Reading                                    //
//                                                                           //
//  Changes:                                                                 //
//    nts: rev 1.0: initial working revision   Mon Jan 21 22:32:49 GMT 2002  //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __STACK_H__
#define __STACK_H__

#include <cassert>

#include "tracker_defines_types_and_helpers.h"  // for MARK, CLEAR_MARK, DEFAULT_STACKSIZE

namespace ReadingPeopleTracker
{

static const char *Stack_Revision = "@(#) Stack.h, rev 1.0 of Mon Jan 21 22:32:49 GMT 2002, Author Nils T Siebel, Copyright (c) 2002 The University of Reading";

typedef unsigned char *cptr;

class Stack
{
    unsigned char **data_stack;
    unsigned char **stackptr;
    unsigned char **stacktop;
    
public:
    Stack(unsigned int size = DEFAULT_STACKSIZE)
	{
	    data_stack = new unsigned char*[size];
	    stackptr = data_stack;
	    stacktop = &data_stack[size];
	}
    
    ~Stack ()
	{
	    delete data_stack;
	}
    
    inline bool is_empty() const
	{
	    return (stackptr == data_stack);
	}
    
    inline void push(const cptr &p)
	{
	    assert (stackptr < stacktop);  // if not we must increase `size' (or DEFAULT_STACKSIZE)
	    
	    if (stackptr < stacktop)
		*(stackptr++) = p;
	}
    
    inline void pop(cptr &p)
	{
	    assert (stackptr > data_stack);  // avoid stack underflow

	    if (stackptr > data_stack)
		p = *(--stackptr);
	}

    inline void test(const cptr &p)
	{
	    if (*(p) == MARK)
	    {
		push(p);
		*(p) = CLEAR_MARK;
	    }
	}
};

} // namespace ReadingPeopleTracker

#endif

