/***************************************************************
 * C - C++ Header
 *
 * File : 	SplineWeights.h
 *
 * Module :	SplineWeights
 *
 * Author : 	A M Baumberg
 *
 * Creation Date : Tue Jan 11 16:30:09 1994 
 *
 * Comments : 	
 *
 ***************************************************************/


#ifndef __SPLINE_WEIGHTS_H__
#define __SPLINE_WEIGHTS_H__

#include "realno.h"
#include "Profile.h"

namespace ReadingPeopleTracker
{

class SplineWeights
{
public:
    static const unsigned int NO_SUBDIVISIONS;
    
    realno *w0, *w1, *w2, *w3;
    realno *dw0, *dw1, *dw2, *dw3;
    unsigned int nsubs;
    SplineWeights(unsigned int n = 0);
    ~SplineWeights() { delete [] w0; delete [] w1; delete [] w2; 
    delete [] w3; delete [] dw0; delete [] dw1;
    delete [] dw2; delete [] dw3; }

    // some helpers
// now in Profile    static void setup_spline_weights();
    static realno B_func(int i, realno u);
    static realno dB_func(int i, realno u);
    static realno ddB_func(int i, realno u);
};

// nts: removed global var Mar 28 2002  extern SplineWeights* spline_weights;

} // namespace ReadingPeopleTracker

#endif
